/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.traits;

import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHEnchantments;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class EnchantmentDisabler {
    private static final String ROOT = "l2hostility_enchantment";
    private static final String OLD = "originalEnchantments";
    private static final String TIME = "startTime";

    public static void disableEnchantment(Level level, ItemStack stack, int duration) {
        ItemEnchantments enchs = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        if (enchs == null) {
            return;
        }
        double durability = stack.getMaxDamage() == 0 ? 0.0 : 1.0 * (double)stack.getDamageValue() / (double)stack.getMaxDamage();
        ItemEnchantments.Mutable retain = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        ItemEnchantments.Mutable disabled = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        for (Object2IntMap.Entry e : enchs.entrySet()) {
            if (((Holder)e.getKey()).is(LHTagGen.NO_DISPELL)) {
                retain.set((Holder)e.getKey(), e.getIntValue());
                continue;
            }
            disabled.set((Holder)e.getKey(), e.getIntValue());
        }
        if (disabled.keySet().isEmpty()) {
            return;
        }
        stack.set(DataComponents.ENCHANTMENTS, (Object)retain.toImmutable());
        LHItems.DC_DISPELL_START.set(stack, (Object)(level.getGameTime() + (long)duration));
        LHItems.DC_DISPELL_ENCH.set(stack, (Object)disabled.toImmutable());
        if (stack.isDamageableItem()) {
            stack.setDamageValue(Mth.clamp((int)((int)Math.floor(durability * (double)stack.getMaxDamage())), (int)0, (int)(stack.getMaxDamage() - 1)));
        }
    }

    public static void tickStack(Level level, Entity user, ItemStack stack) {
        ItemEnchantments disabled;
        if (level.isClientSide()) {
            return;
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            if (!player.getAbilities().instabuild && stack.isEnchanted() && stack.getEnchantmentLevel(LHEnchantments.VANISH.holder()) > 0) {
                stack.setCount(0);
                return;
            }
        }
        if ((disabled = (ItemEnchantments)LHItems.DC_DISPELL_ENCH.get(stack)) == null) {
            return;
        }
        long time = (Long)LHItems.DC_DISPELL_START.getOrDefault(stack, (Object)0L);
        if (level.getGameTime() < time) {
            return;
        }
        stack.remove(LHItems.DC_DISPELL_ENCH);
        stack.remove(LHItems.DC_DISPELL_START);
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(disabled);
        ItemEnchantments enchs = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        if (enchs != null) {
            for (Object2IntMap.Entry e : enchs.entrySet()) {
                builder.set((Holder)e.getKey(), e.getIntValue());
            }
        }
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)builder.toImmutable());
    }

    public static void modifyTooltip(ItemStack stack, List<Component> tooltip, Level level, Item.TooltipContext context, TooltipFlag flags) {
        ItemEnchantments disabled = (ItemEnchantments)LHItems.DC_DISPELL_ENCH.get(stack);
        if (disabled == null) {
            return;
        }
        long time = Math.max(0L, (Long)LHItems.DC_DISPELL_START.getOrDefault(stack, (Object)0L) - level.getGameTime());
        tooltip.add((Component)LangData.TOOLTIP_DISABLE.get(Component.literal((String)("" + disabled.size())).withStyle(ChatFormatting.LIGHT_PURPLE), Component.literal((String)("" + time / 20L)).withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.RED));
        disabled.addToTooltip(context, e -> tooltip.add((Component)e.copy().withStyle(ChatFormatting.DARK_GRAY)), flags);
    }
}

