/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.traits;

import dev.xkmc.l2core.base.effects.EffectBuilder;
import dev.xkmc.l2hostility.init.data.LHConfig;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class EffectBooster {
    public static void boostCharge(LivingEntity target) {
        double factor = 1.0 + (Double)LHConfig.SERVER.drainDuration.get();
        int maxTime = (Integer)LHConfig.SERVER.drainDurationMax.get();
        int min = (Integer)LHConfig.SERVER.witchChargeMinDuration.get();
        EffectBooster.boost(target, e -> e.getCategory() == MobEffectCategory.HARMFUL, min, factor, maxTime);
    }

    public static void boostBottle(LivingEntity target) {
        double factor = 1.0 + (Double)LHConfig.SERVER.drainDuration.get();
        int maxTime = (Integer)LHConfig.SERVER.drainDurationMax.get();
        int min = (Integer)LHConfig.SERVER.witchChargeMinDuration.get();
        EffectBooster.boost(target, e -> true, min, factor, maxTime);
    }

    public static void boostTrait(LivingEntity target, double factor, int maxTime) {
        EffectBooster.boost(target, e -> e.getCategory() == MobEffectCategory.HARMFUL, 0, factor, maxTime);
    }

    private static void boost(LivingEntity target, Predicate<MobEffect> pred, int min, double factor, int maxTime) {
        ArrayList list = new ArrayList(target.getActiveEffects());
        for (MobEffectInstance e : list) {
            int current;
            if (!pred.test((MobEffect)e.getEffect().value()) || (current = e.getDuration()) < min) continue;
            int max = Math.min(maxTime, (int)((double)current * factor));
            if (max > current) {
                new EffectBuilder(e).setDuration(max);
            }
            target.forceAddEffect(e, null);
        }
    }

    public static void boostInfinite(LivingEntity target) {
        int min = (Integer)LHConfig.SERVER.witchChargeMinDuration.get();
        ArrayList list = new ArrayList(target.getActiveEffects());
        for (MobEffectInstance e : list) {
            int current;
            if (((MobEffect)e.getEffect().value()).getCategory() != MobEffectCategory.HARMFUL || (current = e.getDuration()) < min) continue;
            new EffectBuilder(e).setDuration(-1);
            target.forceAddEffect(e, null);
        }
    }
}

