/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.tool;

import dev.xkmc.l2core.base.effects.EffectBuilder;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.content.traits.base.TargetEffectTrait;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class WitchWand
extends Item {
    private static MobEffectInstance getRandom(RegistryAccess access, int maxRank, RandomSource source) {
        List<MobTrait> list = LHTraits.TRAITS.get().stream().filter(e -> e instanceof TargetEffectTrait).toList();
        TargetEffectTrait trait = (TargetEffectTrait)list.get(source.nextInt(list.size()));
        int rank = Math.min(maxRank, trait.getConfig(access).max_rank());
        MobEffectInstance ans = trait.func.apply(rank);
        return new EffectBuilder((MobEffectInstance)ans).setDuration((int)(ans.getDuration() * ((Integer)LHConfig.SERVER.witchWandFactor.get()).intValue())).ins;
    }

    public WitchWand(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.LINGERING_POTION_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.getRandom().nextFloat() * 0.4f + 0.8f));
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            ThrownPotion entity = new ThrownPotion(level, (LivingEntity)player);
            ItemStack potion = new ItemStack((ItemLike)Items.SPLASH_POTION);
            int maxRank = ((PlayerDifficulty)((PlayerCapabilityHolder)LHMiscs.PLAYER.type()).getOrCreate((IAttachmentHolder)player)).maxRankKilled;
            MobEffectInstance ins = WitchWand.getRandom(player.registryAccess(), maxRank, player.getRandom());
            potion.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.of(((MobEffect)ins.getEffect().value()).getColor()), List.of(ins)));
            entity.setItem(potion);
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 1.0f);
            level.addFreshEntity((Entity)entity);
            if (!player.getAbilities().instabuild) {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
        }
        player.getCooldowns().addCooldown((Item)this, 60);
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.ITEM_WITCH_WAND.get(new Object[0]).withStyle(ChatFormatting.GOLD));
    }
}

