/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.tool;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import dev.xkmc.l2magic.content.item.utility.BaseWand;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class TraitAdderWand
extends BaseWand {
    public static ItemStack set(ItemStack ans, MobTrait trait) {
        return LHItems.DC_TRAIT_WAND.set(ans, (Object)trait.holder());
    }

    public static MobTrait get(ItemStack stack) {
        return (MobTrait)((Object)((Holder)LHItems.DC_TRAIT_WAND.getOrDefault(stack, LHTraits.TANK)).value());
    }

    private static List<MobTrait> values() {
        return LHTraits.TRAITS.get().stream().toList();
    }

    private static MobTrait next(MobTrait mod) {
        List<MobTrait> list = TraitAdderWand.values();
        int index = list.indexOf((Object)mod);
        if (index + 1 >= list.size()) {
            return list.getFirst();
        }
        return list.get(index + 1);
    }

    private static MobTrait prev(MobTrait mod) {
        List<MobTrait> list = TraitAdderWand.values();
        int index = list.indexOf((Object)mod);
        if (index == 0) {
            return list.getLast();
        }
        return list.get(index - 1);
    }

    @Nullable
    public static Integer decrease(RegistryAccess access, MobTrait k, @Nullable Integer old) {
        if (old == null || old == 0) {
            return k.getMaxLevel(access);
        }
        if (old == 1) {
            return null;
        }
        return old - 1;
    }

    @Nullable
    public static Integer increase(RegistryAccess access, MobTrait k, @Nullable Integer old) {
        if (old == null) {
            return 1;
        }
        if (old.intValue() == k.getMaxLevel(access)) {
            return null;
        }
        return old + 1;
    }

    public TraitAdderWand(Item.Properties properties) {
        super(properties);
    }

    public void clickTarget(ItemStack stack, Player player, LivingEntity target) {
        Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)target);
        if (opt.isEmpty() && !((GeneralCapabilityHolder)LHMiscs.MOB.type()).isProper((IAttachmentHolder)target)) {
            return;
        }
        MobTraitCap cap = opt.orElse((MobTraitCap)((GeneralCapabilityHolder)LHMiscs.MOB.type()).getOrCreate((IAttachmentHolder)target));
        MobTrait trait = TraitAdderWand.get(stack);
        RegistryAccess access = player.registryAccess();
        Integer ans = player.isShiftKeyDown() ? cap.traits.compute(trait, (k, i) -> TraitAdderWand.decrease(access, k, i)) : cap.traits.compute(trait, (k, i) -> TraitAdderWand.increase(access, k, i));
        int val = ans == null ? 0 : ans;
        trait.initialize(target, val);
        trait.postInit(target, val);
        cap.syncToClient(target);
        target.setHealth(target.getMaxHealth());
        player.sendSystemMessage((Component)LangData.MSG_SET_TRAIT.get(trait.getDesc(), target.getDisplayName(), val));
    }

    public void clickNothing(ItemStack stack, Player player) {
        MobTrait old = TraitAdderWand.get(stack);
        MobTrait next = player.isShiftKeyDown() ? TraitAdderWand.prev(old) : TraitAdderWand.next(old);
        TraitAdderWand.set(stack, next);
        player.sendSystemMessage((Component)LangData.MSG_SELECT_TRAIT.get(next.getDesc()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.ITEM_WAND_ADDER.get(new Object[0]).withStyle(ChatFormatting.GRAY));
        MobTrait trait = TraitAdderWand.get(stack);
        list.add((Component)LangData.MSG_SELECT_TRAIT.get(trait.getDesc().withStyle(ChatFormatting.AQUA)).withStyle(ChatFormatting.GRAY));
    }
}

