/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.spawner;

import dev.xkmc.l2hostility.content.item.spawner.TraitSpawnerBlock;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@SerialClass
public class TraitSpawnerData {
    @SerialField
    private final HashMap<UUID, TrackedEntity> list = new HashMap();
    private boolean init = false;

    protected void init(Level level) {
        if (this.init) {
            return;
        }
        for (TrackedEntity e : this.list.values()) {
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                e.serverInit(sl);
                continue;
            }
            e.clientInit(level);
        }
        this.init = true;
    }

    protected void add(LivingEntity le) {
        TrackedEntity entry = new TrackedEntity();
        entry.uuid = le.getUUID();
        entry.uid = le.getId();
        entry.entity = le;
        entry.state = EntityState.ALIVE;
        this.list.put(entry.uuid, entry);
    }

    public void onDeath(LivingEntity mob) {
        TrackedEntity ans = this.list.get(mob.getUUID());
        if (ans != null) {
            ans.state = EntityState.DEAD;
        }
    }

    protected TraitSpawnerBlock.State tick() {
        boolean hasMissing = false;
        boolean hasAlive = false;
        for (TrackedEntity e : this.list.values()) {
            e.tick();
            hasMissing |= e.state == EntityState.MISSING;
            hasAlive |= e.state == EntityState.ALIVE;
        }
        return hasMissing ? TraitSpawnerBlock.State.FAILED : (hasAlive ? TraitSpawnerBlock.State.ACTIVATED : TraitSpawnerBlock.State.CLEAR);
    }

    protected void stop() {
        for (TrackedEntity e : this.list.values()) {
            if (e.getEntity() == null || e.state != EntityState.ALIVE) continue;
            e.getEntity().discard();
        }
        this.list.clear();
    }

    protected int getMax() {
        return this.list.size();
    }

    protected int getAlive() {
        int i = 0;
        for (TrackedEntity e : this.list.values()) {
            if (e.state != EntityState.ALIVE) continue;
            ++i;
        }
        return i;
    }

    @SerialClass
    public static class TrackedEntity {
        @SerialField
        public UUID uuid;
        @SerialField(toClient=true)
        public int uid;
        @SerialField(toClient=true)
        public EntityState state;
        @Nullable
        private LivingEntity entity;

        private void serverInit(ServerLevel level) {
            this.uid = -1;
            this.entity = null;
            if (this.state == EntityState.ALIVE) {
                Entity entity = level.getEntity(this.uuid);
                if (entity instanceof LivingEntity) {
                    LivingEntity le;
                    this.entity = le = (LivingEntity)entity;
                    this.uid = le.getId();
                } else {
                    this.state = EntityState.MISSING;
                }
            }
        }

        private void clientInit(Level level) {
            LivingEntity le;
            Entity entity;
            this.entity = this.uid > 0 && (entity = level.getEntity(this.uid)) instanceof LivingEntity ? (le = (LivingEntity)entity) : null;
        }

        @Nullable
        public LivingEntity getEntity() {
            if (this.state != EntityState.ALIVE) {
                return null;
            }
            return this.entity == null ? null : (!this.entity.isAlive() ? null : this.entity);
        }

        public void tick() {
            if (this.state != EntityState.ALIVE) {
                return;
            }
            if (this.entity == null) {
                this.state = EntityState.MISSING;
                return;
            }
            if (this.entity.isRemoved() || !this.entity.isAlive()) {
                this.state = EntityState.MISSING;
            }
        }
    }

    public static enum EntityState {
        ALIVE,
        DEAD,
        MISSING;

    }
}

