/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.spawner;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkCapHolder;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.chunk.SectionDifficulty;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.item.spawner.TraitSpawnerBlockEntity;
import dev.xkmc.l2hostility.content.item.spawner.TraitSpawnerData;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LHTagGen;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.event.EventHooks;

@SerialClass
public class BurstSpawnerBlockEntity
extends TraitSpawnerBlockEntity {
    private static WeightedRandomList<MobSpawnSettings.SpawnerData> mobsAt(ServerLevel level, BlockPos pos) {
        StructureManager structure = level.structureManager();
        ChunkGenerator chunkGen = level.getChunkSource().getGenerator();
        Holder biome = level.getBiome(pos);
        return EventHooks.getPotentialSpawns((LevelAccessor)level, (MobCategory)MobCategory.MONSTER, (BlockPos)pos, (WeightedRandomList)chunkGen.getMobsAt(biome, structure, MobCategory.MONSTER, pos));
    }

    public static int getSpawnGroup() {
        return (Integer)LHConfig.SERVER.hostilitySpawnCount.get();
    }

    public static double getBonusFactor() {
        return ((Integer)LHConfig.SERVER.hostilitySpawnLevelFactor.get()).intValue();
    }

    public static int getMaxTrials() {
        return 4;
    }

    public BurstSpawnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected void generate(TraitSpawnerData data) {
        BurstSpawnerBlockEntity other;
        BlockEntity blockEntity;
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        Optional<ChunkCapHolder> cdcap = ChunkDifficulty.at(this.level, this.getBlockPos());
        if (cdcap.isEmpty()) {
            return;
        }
        SectionDifficulty sec = cdcap.get().getSection(this.getBlockPos().getY());
        if (sec.activePos != null && this.level.isLoaded(sec.activePos) && (blockEntity = this.level.getBlockEntity(sec.activePos)) instanceof BurstSpawnerBlockEntity && (other = (BurstSpawnerBlockEntity)blockEntity) != this) {
            other.stop();
        }
        sec.activePos = this.getBlockPos();
        int count = 0;
        for (int i = 0; i < BurstSpawnerBlockEntity.getSpawnGroup() * BurstSpawnerBlockEntity.getMaxTrials(); ++i) {
            Entity entity;
            int x = this.level.getRandom().nextInt(16);
            int y = this.level.getRandom().nextInt(16);
            int z = this.level.getRandom().nextInt(16);
            BlockPos pos = new BlockPos(this.getBlockPos().getX() & 0xFFFFFFF8 | x, this.getBlockPos().getY() & 0xFFFFFFF8 | y, this.getBlockPos().getZ() & 0xFFFFFFF8 | z);
            Optional e = BurstSpawnerBlockEntity.mobsAt(sl, pos).getRandom(this.level.getRandom());
            if (!e.isPresent() || ((MobSpawnSettings.SpawnerData)e.get()).type.is(LHTagGen.HOSTILITY_SPAWNER_BLACKLIST) || (entity = ((MobSpawnSettings.SpawnerData)e.get()).type.create((Level)sl)) == null || entity instanceof Creeper) continue;
            entity.setPos(Vec3.atCenterOf((Vec3i)this.getBlockPos()));
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)entity;
            MobTraitCap cap = (MobTraitCap)((GeneralCapabilityHolder)LHMiscs.MOB.type()).getOrCreate((IAttachmentHolder)le);
            cap.summoned = true;
            cap.noDrop = true;
            cap.pos = this.getBlockPos();
            cap.init(this.level, le, (a, b) -> {
                ((ChunkCapHolder)cdcap.get()).modifyInstance(a, b);
                b.acceptBonusFactor(BurstSpawnerBlockEntity.getBonusFactor());
                b.setFullChance();
            });
            entity.setPos(Vec3.atCenterOf((Vec3i)this.getBlockPos().above()));
            data.add(le);
            this.level.addFreshEntity(entity);
            if (++count >= BurstSpawnerBlockEntity.getSpawnGroup()) break;
        }
    }

    @Override
    protected void clearStage() {
        assert (this.level != null);
        Optional<ChunkCapHolder> cdcap = ChunkDifficulty.at(this.level, this.getBlockPos());
        if (cdcap.isPresent()) {
            SectionDifficulty section = cdcap.get().getSection(this.getBlockPos().getY());
            section.setClear(cdcap.get(), this.getBlockPos());
            section.activePos = null;
        }
    }

    @Override
    protected CustomBossEvent createBossEvent() {
        CustomBossEvent ans = new CustomBossEvent(L2Hostility.loc("hostility_spawner"), (Component)LangData.BOSS_EVENT.get(0, BurstSpawnerBlockEntity.getSpawnGroup()).withStyle(ChatFormatting.GOLD));
        ans.setColor(BossEvent.BossBarColor.PURPLE);
        ans.setOverlay(BossEvent.BossBarOverlay.NOTCHED_10);
        return ans;
    }
}

