/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.curio.misc;

import dev.xkmc.l2core.util.DCStack;
import dev.xkmc.l2hostility.compat.curios.CurioCompat;
import dev.xkmc.l2hostility.compat.curios.EntitySlotAccess;
import dev.xkmc.l2hostility.content.item.curio.core.SingletonItem;
import dev.xkmc.l2hostility.content.item.traits.SealedItem;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.function.Consumers;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class PocketOfRestoration
extends SingletonItem
implements ICurioItem {
    public static void setData(ItemStack stack, ItemStack sealed, String id, long time) {
        DCStack data = (DCStack)LHItems.DC_SEAL_STACK.get(sealed);
        if (data == null) {
            return;
        }
        LHItems.DC_SEAL_STACK.set(stack, (Object)data);
        LHItems.DC_SEAL_TIME.set(stack, (Object)((Integer)LHItems.DC_SEAL_TIME.getOrDefault(sealed, (Object)0)));
        LHItems.DC_UNSEAL_START.set(stack, (Object)time);
        LHItems.DC_UNSEAL_SLOT.set(stack, (Object)id);
    }

    public PocketOfRestoration(Item.Properties properties, int durability) {
        super(properties, durability);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity le = slotContext.entity();
        Level level = le.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (!slotContext.entity().isAlive()) {
            return;
        }
        List<EntitySlotAccess> list = CurioCompat.getItemAccess(le);
        DCStack seal = (DCStack)LHItems.DC_SEAL_STACK.get(stack);
        if (seal != null) {
            long time = (Long)LHItems.DC_UNSEAL_START.getOrDefault(stack, (Object)0L);
            int dur = (Integer)LHItems.DC_SEAL_TIME.getOrDefault(stack, (Object)0);
            String str = (String)LHItems.DC_UNSEAL_SLOT.get(stack);
            if (le.level().getGameTime() >= time + (long)dur && str != null) {
                Player player;
                ItemStack result = seal.stack();
                EntitySlotAccess slot = CurioCompat.decode(str, le);
                if (slot != null && slot.get().isEmpty()) {
                    slot.set(result);
                    stack.remove(LHItems.DC_SEAL_STACK);
                    stack.remove(LHItems.DC_SEAL_TIME);
                    stack.remove(LHItems.DC_UNSEAL_START);
                    stack.remove(LHItems.DC_UNSEAL_SLOT);
                } else if (le instanceof Player && (player = (Player)le).addItem(result)) {
                    stack.remove(LHItems.DC_SEAL_STACK);
                    stack.remove(LHItems.DC_SEAL_TIME);
                    stack.remove(LHItems.DC_UNSEAL_START);
                    stack.remove(LHItems.DC_UNSEAL_SLOT);
                }
            }
            return;
        }
        if (stack.getDamageValue() + 1 >= stack.getMaxDamage()) {
            return;
        }
        for (EntitySlotAccess e : list) {
            if (!(e.get().getItem() instanceof SealedItem)) continue;
            ItemStack item = e.get();
            e.set(ItemStack.EMPTY);
            String id = e.getID();
            long time = le.level().getGameTime();
            stack.hurtAndBreak(1, sl, le, Consumers.nop());
            PocketOfRestoration.setData(stack, item, id, time);
            return;
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.POCKET_OF_RESTORATION.get(new Object[0]).withStyle(ChatFormatting.GOLD));
        DCStack seal = (DCStack)LHItems.DC_SEAL_STACK.get(stack);
        if (seal != null) {
            list.add((Component)LangData.TOOLTIP_SEAL_DATA.get(new Object[0]).withStyle(ChatFormatting.GRAY));
            list.add(seal.stack().getHoverName());
        }
    }

    @Override
    public boolean allowDuplicate() {
        return true;
    }
}

