/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.curio.curse;

import com.google.common.collect.Multimap;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2hostility.content.item.curio.core.CurseCurioItem;
import dev.xkmc.l2hostility.content.logic.DifficultyLevel;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import top.theillusivec4.curios.api.SlotContext;

public class CurseOfPride
extends CurseCurioItem {
    public CurseOfPride(Item.Properties props) {
        super(props);
    }

    @Override
    public void onHurtTarget(ItemStack stack, LivingEntity user, DamageData.Offence cache) {
        int level = DifficultyLevel.ofAny(user);
        double rate = (Double)LHConfig.SERVER.prideDamageBonus.get();
        cache.addHurtModifier(DamageModifier.multTotal((float)((float)(1.0 + (double)level * rate)), (ResourceLocation)this.getID()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        int protect = (int)Math.round(100.0 * (Double)LHConfig.SERVER.prideHealthBonus.get());
        int damage = (int)Math.round(100.0 * (Double)LHConfig.SERVER.prideDamageBonus.get());
        int trait = (int)Math.round(100.0 * (1.0 / (Double)LHConfig.SERVER.prideTraitFactor.get() - 1.0));
        list.add((Component)LangData.ITEM_CHARM_PRIDE.get(protect, damage).withStyle(ChatFormatting.GOLD));
        list.add((Component)LangData.ITEM_CHARM_TRAIT_CHEAP.get(trait).withStyle(ChatFormatting.RED));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity wearer = slotContext.entity();
        if (wearer == null) {
            return;
        }
        int level = DifficultyLevel.ofAny(wearer);
        LHItems.DC_PRIDE_LEVEL.set(stack, (Object)level);
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation uuid, ItemStack stack) {
        Multimap<Holder<Attribute>, AttributeModifier> ans = super.getAttributeModifiers(slotContext, uuid, stack);
        int level = (Integer)LHItems.DC_PRIDE_LEVEL.getOrDefault(stack, (Object)0);
        if (level > 0) {
            double rate = (Double)LHConfig.SERVER.prideHealthBonus.get() * (double)level;
            ans.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(uuid, rate, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        return ans;
    }
}

