/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.item.consumable;

import dev.xkmc.l2hostility.init.data.LangData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BookEverything
extends Item {
    @Nullable
    private static Holder<Enchantment> getEnch(RegistryAccess access, ItemStack stack) {
        String name = stack.getHoverName().getString();
        try {
            ResourceLocation rl = ResourceLocation.parse((String)name.trim());
            Registry reg = access.registryOrThrow(Registries.ENCHANTMENT);
            return reg.getHolder(rl).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean allow(Holder<Enchantment> holder) {
        if (holder.is(EnchantmentTags.TREASURE) || !holder.is(EnchantmentTags.IN_ENCHANTING_TABLE)) {
            return false;
        }
        Enchantment ench = (Enchantment)holder.value();
        return ench.getMaxCost(ench.getMaxLevel()) >= ench.getMinCost(ench.getMaxLevel());
    }

    public static int cost(Enchantment ench) {
        return Math.max(ench.getMaxLevel(), ench.getMaxCost(ench.getMaxLevel()) / 10);
    }

    public BookEverything(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide()) {
                ItemStack result = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                Registry enchreg = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
                ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                enchreg.holders().filter(BookEverything::allow).forEach(e -> builder.set(e.getDelegate(), ((Enchantment)e.value()).getMaxLevel()));
                EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)builder.toImmutable());
                stack.shrink(1);
                if (stack.isEmpty()) {
                    return InteractionResultHolder.success((Object)result);
                }
                player.getInventory().placeItemBackInInventory(result);
            }
            return InteractionResultHolder.consume((Object)stack);
        }
        Holder<Enchantment> ench = BookEverything.getEnch(level.registryAccess(), stack);
        if (ench == null) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!BookEverything.allow(ench)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        int cost = BookEverything.cost((Enchantment)ench.value());
        if (player.experienceLevel < cost) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (!level.isClientSide()) {
            player.giveExperienceLevels(-cost);
            EnchantmentInstance ins = new EnchantmentInstance(ench, ((Enchantment)ench.value()).getMaxLevel());
            ItemStack result = EnchantedBookItem.createForEnchantment((EnchantmentInstance)ins);
            player.getInventory().placeItemBackInInventory(result);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.ITEM_BOOK_EVERYTHING_USE.get(new Object[0]).withStyle(ChatFormatting.GRAY));
        list.add((Component)LangData.ITEM_BOOK_EVERYTHING_SHIFT.get(new Object[0]).withStyle(ChatFormatting.GOLD));
        Level level = ctx.level();
        Holder<Enchantment> holder = null;
        if (level != null) {
            holder = BookEverything.getEnch(level.registryAccess(), stack);
        }
        if (holder == null) {
            list.add((Component)LangData.ITEM_BOOK_EVERYTHING_INVALID.get(new Object[0]).withStyle(ChatFormatting.GRAY));
        } else {
            Enchantment e = (Enchantment)holder.value();
            Component name = Enchantment.getFullname(holder, (int)e.getMaxLevel());
            if (BookEverything.allow(holder)) {
                int cost = BookEverything.cost(e);
                list.add((Component)LangData.ITEM_BOOK_EVERYTHING_READY.get(name, cost).withStyle(ChatFormatting.GREEN));
            } else {
                list.add((Component)LangData.ITEM_BOOK_EVERYTHING_FORBIDDEN.get(name).withStyle(ChatFormatting.RED));
            }
        }
    }
}

