/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.entity;

import dev.xkmc.l2hostility.content.entity.BulletType;
import dev.xkmc.l2hostility.init.registrate.LHEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class HostilityBullet
extends ShulkerBullet {
    private BulletType type;
    private int lv;

    public HostilityBullet(EntityType<HostilityBullet> type, Level level) {
        super(type, level);
    }

    public HostilityBullet(Level level, LivingEntity owner, Entity target, Direction.Axis direction, BulletType type, int lv) {
        this((EntityType<HostilityBullet>)((EntityType)LHEntities.BULLET.get()), level);
        this.setOwner((Entity)owner);
        BlockPos blockpos = owner.blockPosition();
        double d0 = (double)blockpos.getX() + 0.5;
        double d1 = (double)blockpos.getY() + 0.5;
        double d2 = (double)blockpos.getZ() + 0.5;
        this.moveTo(d0, d1, d2, this.getYRot(), this.getXRot());
        this.finalTarget = target;
        this.currentMoveDirection = Direction.UP;
        this.selectNextMoveDirection(direction);
        this.type = type;
        this.lv = lv;
    }

    protected void onHitEntity(EntityHitResult result) {
        if (this.type == null) {
            return;
        }
        Entity target = result.getEntity();
        Entity owner = this.getOwner();
        LivingEntity leowner = owner instanceof LivingEntity ? (LivingEntity)owner : null;
        float damage = this.type.getDamage(this.lv);
        if (damage > 0.0f) {
            target.hurt(this.damageSources().mobProjectile((Entity)this, leowner), damage);
        }
        this.type.onHit(this, (HitResult)result, this.lv);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.type.onHit(this, (HitResult)result, this.lv);
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putString("BulletType", this.type.name());
        tag.putInt("BulletLevel", this.lv);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.type = BulletType.valueOf(tag.getString("BulletType"));
        this.lv = tag.getInt("BulletLevel");
    }

    public boolean isTarget(Entity e) {
        if (e instanceof Player) {
            return true;
        }
        if (e == this.finalTarget) {
            return true;
        }
        if (e instanceof Mob) {
            Mob target = (Mob)e;
            Entity owner = this.getOwner();
            if (owner != null) {
                if (target.getTarget() == owner) {
                    return true;
                }
                if (owner instanceof Mob) {
                    Mob mob = (Mob)owner;
                    return mob.getTarget() == e;
                }
            }
        }
        return false;
    }
}

