/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.config;

import dev.xkmc.l2core.serial.config.BaseConfig;
import dev.xkmc.l2core.serial.config.CollectType;
import dev.xkmc.l2core.serial.config.ConfigCollect;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.apache.commons.lang3.mutable.MutableBoolean;

@SerialClass
public class WorldDifficultyConfig
extends BaseConfig {
    @ConfigCollect(value=CollectType.MAP_OVERWRITE)
    @SerialField
    public final HashMap<ResourceLocation, DifficultyConfig> levelMap = new HashMap();
    @ConfigCollect(value=CollectType.MAP_OVERWRITE)
    @SerialField
    public final HashMap<ResourceLocation, DifficultyConfig> biomeMap = new HashMap();
    @ConfigCollect(value=CollectType.MAP_COLLECT)
    @SerialField
    public final HashMap<ResourceLocation, ArrayList<EntityConfig.Config>> levelDefaultTraits = new HashMap();
    @ConfigCollect(value=CollectType.MAP_COLLECT)
    @SerialField
    public final HashMap<ResourceLocation, ArrayList<EntityConfig.Config>> structureDefaultTraits = new HashMap();

    public static DifficultyConfig defaultLevel() {
        int base = (Integer)LHConfig.SERVER.defaultLevelBase.get();
        double var = (Double)LHConfig.SERVER.defaultLevelVar.get();
        double scale = (Double)LHConfig.SERVER.defaultLevelScale.get();
        return new DifficultyConfig(0, base, var, scale, 1.0, 1.0, 0.0);
    }

    @Nullable
    public EntityConfig.Config get(ServerLevel level, BlockPos pos, EntityType<?> type) {
        if (!((Boolean)LHConfig.SERVER.enableEntitySpecificDatapack.get()).booleanValue()) {
            return null;
        }
        if (!((Boolean)LHConfig.SERVER.enableStructureSpecificDatapack.get()).booleanValue()) {
            return null;
        }
        if (this.structureDefaultTraits.isEmpty()) {
            return null;
        }
        StructureManager manager = level.structureManager();
        Map map = manager.getAllStructuresAt(pos);
        EntityConfig.Config def = null;
        for (Map.Entry ent : map.entrySet()) {
            Structure structure = (Structure)ent.getKey();
            ResourceLocation key = level.registryAccess().registryOrThrow(Registries.STRUCTURE).getKey((Object)structure);
            ArrayList<EntityConfig.Config> list = this.structureDefaultTraits.get(key);
            if (list == null) continue;
            MutableBoolean ans = new MutableBoolean(false);
            manager.fillStartsForStructure(structure, (LongSet)ent.getValue(), e -> {
                if (ans.isFalse() && manager.structureHasPieceAt(pos, e)) {
                    ans.setTrue();
                }
            });
            if (ans.isFalse()) continue;
            for (EntityConfig.Config e2 : list) {
                if (e2.entities.contains((Holder)type.builtInRegistryHolder())) {
                    return e2;
                }
                if (e2.entities.size() != 0) continue;
                def = e2;
            }
        }
        return def;
    }

    @Nullable
    public EntityConfig.Config get(ResourceLocation level, EntityType<?> type) {
        if (!((Boolean)LHConfig.SERVER.enableEntitySpecificDatapack.get()).booleanValue()) {
            return null;
        }
        ArrayList<EntityConfig.Config> list = this.levelDefaultTraits.get(level);
        if (list == null) {
            return null;
        }
        EntityConfig.Config def = null;
        for (EntityConfig.Config e : list) {
            if (e.entities.contains((Holder)type.builtInRegistryHolder())) {
                return e;
            }
            if (e.entities.size() != 0) continue;
            def = e;
        }
        return def;
    }

    public WorldDifficultyConfig putDim(ResourceKey<Level> key, int min, int base, double var, double scale) {
        this.levelMap.put(key.location(), new DifficultyConfig(min, base, var, scale, 1.0, 1.0, 0.0));
        return this;
    }

    @SafeVarargs
    public final WorldDifficultyConfig putBiome(int min, int base, double var, double scale, ResourceKey<Biome> ... keys) {
        for (ResourceKey<Biome> key : keys) {
            this.biomeMap.put(key.location(), new DifficultyConfig(min, base, var, scale, 1.0, 1.0, 0.0));
        }
        return this;
    }

    public WorldDifficultyConfig putLevelDef(ResourceKey<Level> id, EntityConfig.Config config) {
        this.levelDefaultTraits.computeIfAbsent(id.location(), l -> new ArrayList()).add(config);
        return this;
    }

    public WorldDifficultyConfig putStructureDef(ResourceKey<Structure> id, EntityConfig.Config config) {
        this.structureDefaultTraits.computeIfAbsent(id.location(), l -> new ArrayList()).add(config);
        return this;
    }

    public record DifficultyConfig(int min, int base, double variation, double scale, double apply_chance, double trait_chance, double suppression) {
    }
}

