/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.config;

import dev.xkmc.l2core.serial.config.BaseConfig;
import dev.xkmc.l2core.serial.config.CollectType;
import dev.xkmc.l2core.serial.config.ConfigCollect;
import dev.xkmc.l2core.serial.configval.BooleanValueCondition;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class WeaponConfig
extends BaseConfig {
    @SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public final ArrayList<ItemConfig> melee_weapons = new ArrayList();
    @SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public final ArrayList<ItemConfig> armors = new ArrayList();
    @SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public final ArrayList<ItemConfig> ranged_weapons = new ArrayList();
    @SerialField
    @ConfigCollect(value=CollectType.MAP_COLLECT)
    public final LinkedHashMap<HolderSet<EntityType<?>>, ArrayList<ItemConfig>> special_weapons = new LinkedHashMap();
    @SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public final ArrayList<EnchConfig> weapon_enchantments = new ArrayList();
    @SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public final ArrayList<EnchConfig> armor_enchantments = new ArrayList();

    public static ItemStack getRandomMeleeWeapon(int level, RandomSource r, @Nullable ServerPlayer player) {
        WeaponConfig config = (WeaponConfig)L2Hostility.WEAPON.getMerged();
        return WeaponConfig.getRandomWeapon(config.melee_weapons, level, r, player);
    }

    public static ItemStack getRandomArmor(EquipmentSlot slot, int level, RandomSource r, @Nullable ServerPlayer player) {
        WeaponConfig config = (WeaponConfig)L2Hostility.WEAPON.getMerged();
        return WeaponConfig.getRandomArmors(slot, config.armors, level, r, player);
    }

    public static ItemStack getRandomRangedWeapon(int level, RandomSource r, @Nullable ServerPlayer player) {
        WeaponConfig config = (WeaponConfig)L2Hostility.WEAPON.getMerged();
        return WeaponConfig.getRandomWeapon(config.ranged_weapons, level, r, player);
    }

    public static ItemStack getRandomWeapon(ArrayList<ItemConfig> entries, int level, RandomSource r, @Nullable ServerPlayer player) {
        int total = 0;
        ArrayList<ItemConfig> list = new ArrayList<ItemConfig>();
        for (ItemConfig e : entries) {
            if (!e.test(level, player)) continue;
            list.add(e);
            total += e.weight();
        }
        if (total == 0) {
            return ItemStack.EMPTY;
        }
        int val = r.nextInt(total);
        for (ItemConfig e : list) {
            if ((val -= e.weight()) > 0) continue;
            return e.stack.get(r.nextInt(e.stack.size())).copy();
        }
        return ItemStack.EMPTY;
    }

    private static ItemStack getRandomArmors(EquipmentSlot slot, ArrayList<ItemConfig> entries, int level, RandomSource r, @Nullable ServerPlayer player) {
        int total = 0;
        ArrayList<ItemConfig> list = new ArrayList<ItemConfig>();
        for (ItemConfig e : entries) {
            if (!e.test(level, player)) continue;
            ArrayList<ItemStack> sub = new ArrayList<ItemStack>();
            for (ItemStack item : e.stack) {
                ArmorItem eq;
                Item item2;
                if (!item.isEmpty() && (!((item2 = item.getItem()) instanceof ArmorItem) || (eq = (ArmorItem)item2).getEquipmentSlot() != slot) && item.getEquipmentSlot() != slot) continue;
                sub.add(item);
            }
            if (sub.isEmpty()) continue;
            list.add(new ItemConfig(sub, e.level, e.weight));
            total += e.weight();
        }
        if (total == 0) {
            return ItemStack.EMPTY;
        }
        int val = r.nextInt(total);
        for (ItemConfig e : list) {
            if ((val -= e.weight()) > 0) continue;
            return e.stack.get(r.nextInt(e.stack.size())).copy();
        }
        return ItemStack.EMPTY;
    }

    public WeaponConfig putMeleeWeapon(int level, int weight, Item ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Item e : items) {
            list.add(e.getDefaultInstance());
        }
        this.melee_weapons.add(new ItemConfig(list, level, weight));
        return this;
    }

    public WeaponConfig putArmor(int level, int weight, Item ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Item e : items) {
            list.add(e.getDefaultInstance());
        }
        this.armors.add(new ItemConfig(list, level, weight));
        return this;
    }

    public WeaponConfig putRangedWeapon(int level, int weight, Item ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Item e : items) {
            list.add(e.getDefaultInstance());
        }
        this.ranged_weapons.add(new ItemConfig(list, level, weight));
        return this;
    }

    @SafeVarargs
    public final WeaponConfig putWeaponEnch(int level, float chance, ResourceKey<Enchantment> ... items) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(Stream.of(items).map(ResourceKey::location).toList());
        this.weapon_enchantments.add(new EnchConfig(list, level, chance));
        return this;
    }

    @SafeVarargs
    public final WeaponConfig putArmorEnch(int level, float chance, ResourceKey<Enchantment> ... items) {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(Stream.of(items).map(ResourceKey::location).toList());
        this.armor_enchantments.add(new EnchConfig(list, level, chance));
        return this;
    }

    public record ItemConfig(ArrayList<ItemStack> stack, int level, int weight, @Nullable ItemCondition condition) {
        public static final ItemConfig EMPTY = new ItemConfig(new ArrayList<ItemStack>(List.of(ItemStack.EMPTY)), 0, 1000);

        public ItemConfig(ArrayList<ItemStack> stack, int level, int weight) {
            this(stack, level, weight, null);
        }

        public boolean test(int lv, @Nullable ServerPlayer player) {
            if (lv < this.level()) {
                return false;
            }
            return this.condition == null || this.condition.test(player);
        }
    }

    public record EnchConfig(ArrayList<ResourceLocation> enchantments, int level, float chance) {
    }

    public record ItemCondition(ArrayList<ResourceLocation> advancements, @Nullable BooleanValueCondition config) {
        public boolean test(@Nullable ServerPlayer sp) {
            if (this.config != null && !this.config.test(null)) {
                return false;
            }
            if (!this.advancements.isEmpty()) {
                if (sp == null) {
                    return false;
                }
                MinecraftServer server = sp.level().getServer();
                if (server == null) {
                    return false;
                }
                ServerAdvancementManager manager = server.getAdvancements();
                PlayerAdvancements spAdv = sp.getAdvancements();
                for (ResourceLocation e : this.advancements) {
                    AdvancementHolder adv = manager.get(e);
                    if (adv == null) {
                        return false;
                    }
                    if (spAdv.getOrStartProgress(adv).isDone()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

