/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.config;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2core.serial.config.BaseConfig;
import dev.xkmc.l2core.serial.config.CollectType;
import dev.xkmc.l2core.serial.config.ConfigCollect;
import dev.xkmc.l2hostility.content.config.SpecialConfigCondition;
import dev.xkmc.l2hostility.content.config.WorldDifficultyConfig;
import dev.xkmc.l2hostility.content.logic.MobDifficultyCollector;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

@SerialClass
public class EntityConfig
extends BaseConfig {
    @SerialField
    @ConfigCollect(value=CollectType.COLLECT)
    public final ArrayList<Config> list = new ArrayList();
    private final Map<EntityType<?>, Config> cache = new HashMap();
    private final Map<ResourceLocation, ArrayList<Pair<SpecialConfigCondition<?>, Config>>> conditions = new HashMap();

    public static boolean allow(EntityType<?> type, MobTrait trait) {
        Config config = ((EntityConfig)L2Hostility.ENTITY.getMerged()).get(type);
        if (config == null) {
            return true;
        }
        return !config.blacklist.contains((Object)trait);
    }

    protected void postMerge() {
        for (Config e : this.list) {
            if (e.specialConditions.isEmpty()) {
                for (Holder type : e.entities) {
                    this.cache.put((EntityType)type.value(), e);
                }
                continue;
            }
            for (SpecialConfigCondition<?> str : e.specialConditions) {
                this.conditions.computeIfAbsent(str.id, k -> new ArrayList()).add(Pair.of(str, (Object)e));
            }
        }
    }

    @Nullable
    public Config get(EntityType<?> type) {
        if (!((Boolean)LHConfig.SERVER.enableEntitySpecificDatapack.get()).booleanValue()) {
            return null;
        }
        return this.cache.get(type);
    }

    @Nullable
    public <T> Config get(EntityType<?> type, ResourceLocation id, Class<T> cls, T obj) {
        if (!((Boolean)LHConfig.SERVER.enableEntitySpecificDatapack.get()).booleanValue()) {
            return null;
        }
        ArrayList<Pair<SpecialConfigCondition<?>, Config>> list = this.conditions.get(id);
        if (list == null) {
            return null;
        }
        for (Pair<SpecialConfigCondition<?>, Config> pair : list) {
            SpecialConfigCondition cond = (SpecialConfigCondition)pair.getFirst();
            if (!((Config)pair.getSecond()).entities.contains((Holder)type.builtInRegistryHolder()) || cond.cls() != cls || !cond.test(Wrappers.cast(obj))) continue;
            return (Config)pair.getSecond();
        }
        return null;
    }

    public final EntityConfig putEntity(int min, int base, double var, double scale, List<EntityType<?>> keys, List<TraitBase> traits) {
        return this.putEntityAndItem(min, base, var, scale, keys, traits, List.of());
    }

    public final EntityConfig putEntity(int min, int base, double var, double scale, double hp, double atk, List<EntityType<?>> keys, List<TraitBase> traits) {
        return this.putEntityAndItem(min, base, var, scale, hp, atk, keys, traits, List.of());
    }

    public final EntityConfig putEntityAndItem(int min, int base, double var, double scale, List<EntityType<?>> keys, List<TraitBase> traits, List<ItemPool> items) {
        return this.put(EntityConfig.entity(min, base, var, scale, 1.0, 1.0, keys).trait(traits).item(items));
    }

    public final EntityConfig putEntityAndItem(int min, int base, double var, double scale, double hp, double atk, List<EntityType<?>> keys, List<TraitBase> traits, List<ItemPool> items) {
        return this.put(EntityConfig.entity(min, base, var, scale, hp, atk, keys).trait(traits).item(items));
    }

    public final EntityConfig put(Config config) {
        this.list.add(config);
        return this;
    }

    public static Config entity(int min, int base, double var, double scale, List<EntityType<?>> keys) {
        return EntityConfig.entity(min, base, var, scale, 1.0, 1.0, keys);
    }

    public static Config entity(int min, int base, double var, double scale, double hp, double atk, List<EntityType<?>> keys) {
        Config ans = new Config(new ArrayList(keys), new WorldDifficultyConfig.DifficultyConfig(min, base, var, scale, 1.0, 1.0, 0.0));
        ans.attackScale = atk;
        ans.healthScale = hp;
        return ans;
    }

    public static ItemPool simplePool(int level, String slot, ItemStack stack) {
        return new ItemPool(level, 1.0f, slot, new ArrayList<ItemEntry>(List.of(new ItemEntry(100, stack))));
    }

    public static TraitBase trait(MobTrait trait, int free, int min) {
        return new TraitBase(trait, free, min, null);
    }

    public static TraitBase trait(MobTrait trait, int free, int min, int lv, float chance) {
        return new TraitBase(trait, free, min, new TraitCondition(lv, chance, null));
    }

    @SerialClass
    public static class Config {
        @SerialField
        public HolderSet<EntityType<?>> entities = HolderSet.empty();
        @SerialField
        private final ArrayList<SpecialConfigCondition<?>> specialConditions = new ArrayList();
        @SerialField
        private final ArrayList<TraitBase> traits = new ArrayList();
        @SerialField
        private final LinkedHashSet<MobTrait> blacklist = new LinkedHashSet();
        @SerialField
        private WorldDifficultyConfig.DifficultyConfig difficulty = new WorldDifficultyConfig.DifficultyConfig(0, 0, 0.0, 0.0, 1.0, 1.0, 0.0);
        @SerialField
        public final ArrayList<ItemPool> items = new ArrayList();
        @SerialField
        public int minSpawnLevel = 0;
        @SerialField
        public int maxLevel = 0;
        @SerialField
        public int maxTraitCount = -1;
        @SerialField
        public double healthScale = 1.0;
        @SerialField
        public double attackScale = 1.0;
        @SerialField
        public MasterConfig asMaster = null;

        @Deprecated
        public Config() {
        }

        public Config(List<EntityType<?>> entities, WorldDifficultyConfig.DifficultyConfig difficulty) {
            this.entities = HolderSet.direct(EntityType::builtInRegistryHolder, entities);
            this.difficulty = difficulty;
        }

        public Set<MobTrait> blacklist() {
            return this.blacklist;
        }

        public List<TraitBase> traits() {
            return this.traits;
        }

        public WorldDifficultyConfig.DifficultyConfig difficulty() {
            return this.difficulty;
        }

        public Config minLevel(int level) {
            this.minSpawnLevel = level;
            return this;
        }

        public Config trait(List<TraitBase> list) {
            this.traits.addAll(list);
            return this;
        }

        public Config item(List<ItemPool> list) {
            this.items.addAll(list);
            return this;
        }

        public Config conditions(SpecialConfigCondition<?> list) {
            this.specialConditions.add(list);
            return this;
        }

        public Config blacklist(MobTrait ... list) {
            Collections.addAll(this.blacklist, list);
            return this;
        }

        public Config master(int maxTotal, int interval, Minion ... minions) {
            this.asMaster = new MasterConfig(maxTotal, interval, new ArrayList<Minion>(List.of(minions)));
            return this;
        }
    }

    public record ItemPool(int level, float chance, String slot, ArrayList<ItemEntry> entries) {
    }

    public record ItemEntry(int weight, ItemStack stack) {
    }

    public record TraitBase(MobTrait trait, int free, int min, @Nullable TraitCondition condition) {
    }

    public record TraitCondition(int lv, float chance, @Nullable ResourceLocation id) {
        public boolean match(LivingEntity entity, int mobLevel, MobDifficultyCollector ins) {
            if (entity.getRandom().nextDouble() > (double)this.chance) {
                return false;
            }
            if (mobLevel < this.lv) {
                return false;
            }
            return this.id == null || ins.hasAdvancement(this.id);
        }
    }

    public record Minion(EntityType<?> type, int maxCount, int minLevel, double maxHealthPercentage, int spawnRange, int cooldown, boolean copyLevel, boolean copyTrait, double linkDistance, boolean protectMaster, boolean discardOnUnlink, @Nullable Config traits) {
        public Minion(EntityType<?> type, int maxCount, int minLevel, double maxHealthPercentage, int spawnRange, int cooldown, boolean copyLevel, boolean copyTrait, double linkDistance, boolean protectMaster, boolean discardOnUnlink) {
            this(type, maxCount, minLevel, maxHealthPercentage, spawnRange, cooldown, copyLevel, copyTrait, linkDistance, protectMaster, discardOnUnlink, null);
        }
    }

    public record MasterConfig(int maxTotalCount, int spawnInterval, ArrayList<Minion> minions) {
    }
}

