/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.chunk.SectionDifficulty;
import dev.xkmc.l2hostility.content.command.HostilityCommands;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.data.LangData;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class LHRegionCommands
extends HostilityCommands {
    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LHRegionCommands.literal("region").then(LHRegionCommands.section())).then(LHRegionCommands.area());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> section() {
        return (LiteralArgumentBuilder)LHRegionCommands.literal("section").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)LHRegionCommands.argument("pos", BlockPosArgument.blockPos()).then(((LiteralArgumentBuilder)LHRegionCommands.literal("set_base").requires(e -> e.hasPermission(2))).then(LHRegionCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHRegionCommands.sectionLevel((section, level, pos, lv) -> section.getLevelEditor(level, pos).setBase(lv)))))).then(((LiteralArgumentBuilder)LHRegionCommands.literal("add_base").requires(e -> e.hasPermission(2))).then(LHRegionCommands.argument("level", IntegerArgumentType.integer()).executes(LHRegionCommands.sectionLevel((section, level, pos, lv) -> section.getLevelEditor(level, pos).addBase(lv)))))).then(((LiteralArgumentBuilder)LHRegionCommands.literal("set_clear").requires(e -> e.hasPermission(2))).executes(LHRegionCommands.sectionRun((section, level, pos) -> section.setClear(ChunkDifficulty.at(level, pos).get(), pos))))).then(((LiteralArgumentBuilder)LHRegionCommands.literal("set_unclear").requires(e -> e.hasPermission(2))).executes(LHRegionCommands.sectionRun((section, level, pos) -> section.setUnclear(ChunkDifficulty.at(level, pos).get(), pos))))).then(LHRegionCommands.literal("get_base").executes(LHRegionCommands.sectionGet((section, level, pos) -> LangData.COMMAND_REGION_GET_BASE.get(section.getLevelEditor(level, pos).getBase()))))).then(LHRegionCommands.literal("get_total").executes(LHRegionCommands.sectionGet((section, level, pos) -> LangData.COMMAND_REGION_GET_TOTAL.get(section.getLevelEditor(level, pos).getTotal()))))).then(LHRegionCommands.literal("get_scale").executes(LHRegionCommands.sectionGet((section, level, pos) -> LangData.COMMAND_REGION_GET_SCALE.get(section.getScale(level, pos)))))).then(LHRegionCommands.literal("is_clear").executes(LHRegionCommands.sectionGet((section, level, pos) -> section.isCleared() ? LangData.COMMAND_REGION_CLEAR.get(new Object[0]) : LangData.COMMAND_REGION_NOT_CLEAR.get(new Object[0])))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> area() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LHRegionCommands.literal("area").requires(e -> e.hasPermission(2))).then(LHRegionCommands.argument("from", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)LHRegionCommands.argument("to", BlockPosArgument.blockPos()).then(LHRegionCommands.literal("set_base").then(LHRegionCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHRegionCommands.areaLevel((section, level, pos, lv) -> section.getLevelEditor(level, pos).setBase(lv)))))).then(LHRegionCommands.literal("add_base").then(LHRegionCommands.argument("level", IntegerArgumentType.integer()).executes(LHRegionCommands.areaLevel((section, level, pos, lv) -> section.getLevelEditor(level, pos).addBase(lv)))))).then(LHRegionCommands.literal("set_clear").executes(LHRegionCommands.areaRun((section, level, pos) -> section.setClear(ChunkDifficulty.at(level, pos).get(), pos))))).then(LHRegionCommands.literal("set_unclear").executes(LHRegionCommands.areaRun((section, level, pos) -> section.setUnclear(ChunkDifficulty.at(level, pos).get(), pos))))));
    }

    private static Command<CommandSourceStack> sectionLevel(SectionLevelCommand cmd) {
        return ctx -> {
            int level = (Integer)ctx.getArgument("level", Integer.class);
            BlockPos sel = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos");
            Optional<SectionDifficulty> e = SectionDifficulty.sectionAt((Level)((CommandSourceStack)ctx.getSource()).getLevel(), sel);
            if (e.isEmpty()) {
                throw BlockPosArgument.ERROR_NOT_LOADED.create();
            }
            if (!((Boolean)LHConfig.SERVER.allowSectionDifficulty.get()).booleanValue()) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)LangData.COMMAND_REGION_LOCAL_OFF.get(new Object[0]).withStyle(ChatFormatting.RED));
                return 1;
            }
            cmd.run(e.get(), (Level)((CommandSourceStack)ctx.getSource()).getLevel(), sel, level);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)LangData.COMMAND_REGION_SUCCEED.get(new Object[0]));
            return 0;
        };
    }

    private static Command<CommandSourceStack> sectionRun(SectionCommand cmd) {
        return ctx -> {
            BlockPos sel = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos");
            Optional<SectionDifficulty> e = SectionDifficulty.sectionAt((Level)((CommandSourceStack)ctx.getSource()).getLevel(), sel);
            if (e.isEmpty()) {
                throw BlockPosArgument.ERROR_NOT_LOADED.create();
            }
            cmd.run(e.get(), (Level)((CommandSourceStack)ctx.getSource()).getLevel(), sel);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)LangData.COMMAND_REGION_SUCCEED.get(new Object[0]));
            return 0;
        };
    }

    private static Command<CommandSourceStack> sectionGet(SectionGet cmd) {
        return ctx -> {
            BlockPos sel = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos");
            Optional<SectionDifficulty> e = SectionDifficulty.sectionAt((Level)((CommandSourceStack)ctx.getSource()).getLevel(), sel);
            if (e.isEmpty()) {
                throw BlockPosArgument.ERROR_NOT_LOADED.create();
            }
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage(cmd.run(e.get(), (Level)((CommandSourceStack)ctx.getSource()).getLevel(), sel));
            return 0;
        };
    }

    private static Command<CommandSourceStack> areaLevel(SectionLevelCommand cmd) {
        return ctx -> {
            int level = (Integer)ctx.getArgument("level", Integer.class);
            BlockPos from = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"from");
            BlockPos to = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"to");
            if (!((Boolean)LHConfig.SERVER.allowSectionDifficulty.get()).booleanValue()) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)LangData.COMMAND_REGION_LOCAL_OFF.get(new Object[0]).withStyle(ChatFormatting.RED));
                return 1;
            }
            int count = LHRegionCommands.iterate(from, to, sel -> {
                Optional<SectionDifficulty> e = SectionDifficulty.sectionAt((Level)((CommandSourceStack)ctx.getSource()).getLevel(), sel);
                if (e.isEmpty()) {
                    return false;
                }
                return cmd.run(e.get(), (Level)((CommandSourceStack)ctx.getSource()).getLevel(), (BlockPos)sel, level);
            });
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)LangData.COMMAND_REGION_COUNT.get(count));
            return 0;
        };
    }

    private static Command<CommandSourceStack> areaRun(SectionCommand cmd) {
        return ctx -> {
            BlockPos from = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"from");
            BlockPos to = BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"to");
            int count = LHRegionCommands.iterate(from, to, sel -> {
                Optional<SectionDifficulty> e = SectionDifficulty.sectionAt((Level)((CommandSourceStack)ctx.getSource()).getLevel(), sel);
                if (e.isEmpty()) {
                    return false;
                }
                return cmd.run(e.get(), (Level)((CommandSourceStack)ctx.getSource()).getLevel(), (BlockPos)sel);
            });
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)LangData.COMMAND_REGION_COUNT.get(count));
            return 0;
        };
    }

    private static int iterate(BlockPos from, BlockPos to, Predicate<BlockPos> pred) {
        AABB aabb = AABB.encapsulatingFullBlocks((BlockPos)from, (BlockPos)to);
        int x0 = (int)aabb.minX & 0xFFFFFFF1;
        int y0 = (int)aabb.minY & 0xFFFFFFF1;
        int z0 = (int)aabb.minZ & 0xFFFFFFF1;
        int x1 = (int)aabb.maxX & 0xFFFFFFF1;
        int y1 = (int)aabb.maxY & 0xFFFFFFF1;
        int z1 = (int)aabb.maxZ & 0xFFFFFFF1;
        int count = 0;
        for (int x = x0; x <= x1; x += 16) {
            for (int y = y0; y <= y1; y += 16) {
                for (int z = z0; z <= z1; z += 16) {
                    if (!pred.test(new BlockPos(x, y, z))) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    private static interface SectionLevelCommand {
        public boolean run(SectionDifficulty var1, Level var2, BlockPos var3, int var4);
    }

    private static interface SectionCommand {
        public boolean run(SectionDifficulty var1, Level var2, BlockPos var3);
    }

    private static interface SectionGet {
        public Component run(SectionDifficulty var1, Level var2, BlockPos var3);
    }
}

