/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import dev.xkmc.l2core.capability.player.PlayerCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.player.PlayerDifficulty;
import dev.xkmc.l2hostility.content.command.HostilityCommands;
import dev.xkmc.l2hostility.content.logic.TraitManager;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class LHPlayerCommands
extends HostilityCommands {
    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)LHPlayerCommands.literal("player").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)LHPlayerCommands.argument("player", EntityArgument.players()).then(LHPlayerCommands.difficulty())).then(LHPlayerCommands.trait())).then(LHPlayerCommands.dim()));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> difficulty() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LHPlayerCommands.literal("difficulty").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LHPlayerCommands.literal("base").then(((LiteralArgumentBuilder)LHPlayerCommands.literal("set").requires(e -> e.hasPermission(2))).then(LHPlayerCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHPlayerCommands.playerLevel((cap, pl, level) -> cap.getLevelEditor(pl).setBase(level)))))).then(((LiteralArgumentBuilder)LHPlayerCommands.literal("add").requires(e -> e.hasPermission(2))).then(LHPlayerCommands.argument("level", IntegerArgumentType.integer()).executes(LHPlayerCommands.playerLevel((cap, pl, level) -> cap.getLevelEditor(pl).addBase(level)))))).then(LHPlayerCommands.literal("get").executes(LHPlayerCommands.playerGet((cap, pl) -> LangData.COMMAND_PLAYER_GET_BASE.get(pl.getDisplayName(), cap.getLevelEditor(pl).getBase())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)LHPlayerCommands.literal("total").then(((LiteralArgumentBuilder)LHPlayerCommands.literal("set").requires(e -> e.hasPermission(2))).then(LHPlayerCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHPlayerCommands.playerLevel((cap, pl, level) -> cap.getLevelEditor(pl).setTotal(level)))))).then(((LiteralArgumentBuilder)LHPlayerCommands.literal("add").requires(e -> e.hasPermission(2))).then(LHPlayerCommands.argument("level", IntegerArgumentType.integer()).executes(LHPlayerCommands.playerLevel((cap, pl, level) -> cap.getLevelEditor(pl).addTotal(level)))))).then(LHPlayerCommands.literal("get").executes(LHPlayerCommands.playerGet((cap, pl) -> LangData.COMMAND_PLAYER_GET_TOTAL.get(pl.getDisplayName(), cap.getLevelEditor(pl).getTotal())))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> trait() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LHPlayerCommands.literal("traitCap").then(((LiteralArgumentBuilder)LHPlayerCommands.literal("set").requires(e -> e.hasPermission(2))).then(LHPlayerCommands.argument("level", IntegerArgumentType.integer((int)0, (int)TraitManager.getMaxLevel())).executes(LHPlayerCommands.playerLevel((cap, pl, level) -> {
            cap.maxRankKilled = level;
            return true;
        }))))).then(LHPlayerCommands.literal("get").executes(LHPlayerCommands.playerGet((cap, pl) -> LangData.COMMAND_PLAYER_GET_TRAIT_CAP.get(pl.getDisplayName(), cap.maxRankKilled))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> dim() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LHPlayerCommands.literal("dimensions").then(((LiteralArgumentBuilder)LHPlayerCommands.literal("clear").requires(e -> e.hasPermission(2))).executes(LHPlayerCommands.playerRun((cap, pl) -> {
            boolean ans = !cap.dimensions.isEmpty();
            cap.dimensions.clear();
            return ans;
        })))).then(LHPlayerCommands.literal("get").executes(LHPlayerCommands.playerGet((cap, pl) -> LangData.COMMAND_PLAYER_GET_DIM.get(pl.getDisplayName(), cap.dimensions.size()))));
    }

    private static Command<CommandSourceStack> playerRun(PlayerCommand cmd) {
        return ctx -> {
            EntitySelector sel = (EntitySelector)ctx.getArgument("player", EntitySelector.class);
            List list = sel.findPlayers((CommandSourceStack)ctx.getSource());
            int count = LHPlayerCommands.iterate(list, cmd::run);
            LHPlayerCommands.printCompletion((CommandSourceStack)ctx.getSource(), count);
            return 0;
        };
    }

    private static Command<CommandSourceStack> playerGet(PlayerGet cmd) {
        return ctx -> {
            EntitySelector sel = (EntitySelector)ctx.getArgument("player", EntitySelector.class);
            List list = sel.findPlayers((CommandSourceStack)ctx.getSource());
            for (ServerPlayer e : list) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage(cmd.run((PlayerDifficulty)((PlayerCapabilityHolder)LHMiscs.PLAYER.type()).getOrCreate((IAttachmentHolder)e), (Player)e));
            }
            return 0;
        };
    }

    private static Command<CommandSourceStack> playerLevel(PlayerLevelCommand cmd) {
        return ctx -> {
            int level = (Integer)ctx.getArgument("level", Integer.class);
            EntitySelector sel = (EntitySelector)ctx.getArgument("player", EntitySelector.class);
            List list = sel.findPlayers((CommandSourceStack)ctx.getSource());
            int count = LHPlayerCommands.iterate(list, (cap, pl) -> cmd.run((PlayerDifficulty)((Object)((Object)cap)), (Player)pl, level));
            LHPlayerCommands.printCompletion((CommandSourceStack)ctx.getSource(), count);
            return 0;
        };
    }

    private static int iterate(List<ServerPlayer> list, BiPredicate<PlayerDifficulty, Player> task) {
        int count = 0;
        for (ServerPlayer e : list) {
            PlayerDifficulty cap = (PlayerDifficulty)((PlayerCapabilityHolder)LHMiscs.PLAYER.type()).getOrCreate((IAttachmentHolder)e);
            if (!task.test(cap, (Player)e)) continue;
            cap.sync(e);
            ++count;
        }
        return count;
    }

    private static void printCompletion(CommandSourceStack ctx, int count) {
        if (count > 0) {
            ctx.sendSystemMessage((Component)LangData.COMMAND_PLAYER_SUCCEED.get(count));
        } else {
            ctx.sendSystemMessage((Component)LangData.COMMAND_PLAYER_FAIL.get(new Object[0]).withStyle(ChatFormatting.RED));
        }
    }

    private static interface PlayerLevelCommand {
        public boolean run(PlayerDifficulty var1, Player var2, int var3);
    }

    private static interface PlayerGet {
        public Component run(PlayerDifficulty var1, Player var2);
    }

    private static interface PlayerCommand {
        public boolean run(PlayerDifficulty var1, Player var2);
    }
}

