/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.command.HostilityCommands;
import dev.xkmc.l2hostility.content.traits.base.MobTrait;
import dev.xkmc.l2hostility.init.data.LangData;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2hostility.init.registrate.LHTraits;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class LHMobCommands
extends HostilityCommands {
    private static final DynamicCommandExceptionType ERR_INVALID_NAME = new DynamicCommandExceptionType(xva$0 -> LangData.COMMAND_INVALID_TRAIT.get(xva$0));

    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)LHMobCommands.literal("mobs").then(((RequiredArgumentBuilder)LHMobCommands.argument("targets", EntityArgument.entities()).then(LHMobCommands.level())).then(LHMobCommands.trait()));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> trait() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LHMobCommands.literal("trait").then(((LiteralArgumentBuilder)LHMobCommands.literal("clear").requires(e -> e.hasPermission(2))).executes(LHMobCommands.mobRun(LHMobCommands::commandClearTrait)))).then(((LiteralArgumentBuilder)LHMobCommands.literal("remove").requires(e -> e.hasPermission(2))).then(LHMobCommands.argument("trait", ResourceKeyArgument.key((ResourceKey)LHTraits.TRAITS.key())).executes(LHMobCommands.mobTrait(LHMobCommands::commandRemoveTrait))))).then(((LiteralArgumentBuilder)LHMobCommands.literal("set").requires(e -> e.hasPermission(2))).then(LHMobCommands.argument("trait", ResourceKeyArgument.key((ResourceKey)LHTraits.TRAITS.key())).then(LHMobCommands.argument("rank", IntegerArgumentType.integer((int)0)).executes(LHMobCommands.mobTraitRank(LHMobCommands::commandSetTrait)))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> level() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LHMobCommands.literal("level").then(((LiteralArgumentBuilder)LHMobCommands.literal("rerollTrait").requires(e -> e.hasPermission(2))).executes(LHMobCommands.mobRun((mob, cap) -> cap.reinit(mob, cap.getLevel(), false))))).then(((LiteralArgumentBuilder)LHMobCommands.literal("rerollTraitNoSuppression").requires(e -> e.hasPermission(2))).executes(LHMobCommands.mobRun((mob, cap) -> cap.reinit(mob, cap.getLevel(), true))))).then(((LiteralArgumentBuilder)LHMobCommands.literal("setAndRerollTrait").requires(e -> e.hasPermission(2))).then(LHMobCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHMobCommands.mobLevel((mob, cap, level) -> cap.reinit(mob, level, false)))))).then(((LiteralArgumentBuilder)LHMobCommands.literal("addAndRerollTrait").requires(e -> e.hasPermission(2))).then(LHMobCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHMobCommands.mobLevel((mob, cap, level) -> cap.reinit(mob, cap.getLevel() + level, false)))))).then(((LiteralArgumentBuilder)LHMobCommands.literal("set").requires(e -> e.hasPermission(2))).then(LHMobCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHMobCommands.mobLevel((mob, cap, level) -> LHMobCommands.commandSetLevel(cap, mob, level)))))).then(((LiteralArgumentBuilder)LHMobCommands.literal("add").requires(e -> e.hasPermission(2))).then(LHMobCommands.argument("level", IntegerArgumentType.integer((int)0)).executes(LHMobCommands.mobLevel((mob, cap, level) -> LHMobCommands.commandSetLevel(cap, mob, cap.getLevel() + level)))));
    }

    private static boolean commandSetLevel(MobTraitCap cap, LivingEntity mob, int level) {
        cap.setLevel(mob, level);
        cap.syncToClient(mob);
        return true;
    }

    private static boolean commandClearTrait(LivingEntity le, MobTraitCap cap) {
        if (cap.traits.isEmpty()) {
            return false;
        }
        for (MobTrait e : cap.traits.keySet()) {
            cap.setTrait(e, 0);
        }
        return true;
    }

    private static boolean commandRemoveTrait(LivingEntity le, MobTraitCap cap, MobTrait trait) {
        if (!cap.hasTrait(trait)) {
            return false;
        }
        cap.removeTrait(trait);
        return true;
    }

    private static boolean commandSetTrait(LivingEntity le, MobTraitCap cap, MobTrait trait, int rank) {
        if (!trait.allow(le)) {
            return false;
        }
        if (trait.getConfig(le.registryAccess()).max_rank() < rank) {
            return false;
        }
        cap.setTrait(trait, rank);
        return true;
    }

    private static Command<CommandSourceStack> mobRun(MobCommand cmd) {
        return ctx -> {
            Collection list = EntityArgument.getEntities((CommandContext)ctx, (String)"targets");
            int count = LHMobCommands.iterate(list, cmd::run);
            LHMobCommands.printCompletion((CommandSourceStack)ctx.getSource(), count);
            return 0;
        };
    }

    private static Command<CommandSourceStack> mobLevel(MobLevelCommand cmd) {
        return ctx -> {
            int level = (Integer)ctx.getArgument("level", Integer.class);
            Collection list = EntityArgument.getEntities((CommandContext)ctx, (String)"targets");
            int count = LHMobCommands.iterate(list, (le, cap) -> cmd.run((LivingEntity)le, (MobTraitCap)((Object)((Object)cap)), level));
            LHMobCommands.printCompletion((CommandSourceStack)ctx.getSource(), count);
            return 0;
        };
    }

    private static Command<CommandSourceStack> mobTrait(MobTraitCommand cmd) {
        return ctx -> {
            Holder.Reference trait = LHMobCommands.resolveKey((CommandContext<CommandSourceStack>)ctx, "trait", LHTraits.TRAITS.key(), ERR_INVALID_NAME);
            Collection list = EntityArgument.getEntities((CommandContext)ctx, (String)"targets");
            int count = LHMobCommands.iterate(list, (le, cap) -> cmd.run((LivingEntity)le, (MobTraitCap)((Object)((Object)cap)), (MobTrait)((Object)((Object)((Object)trait.value())))));
            LHMobCommands.printCompletion((CommandSourceStack)ctx.getSource(), count);
            return 0;
        };
    }

    private static Command<CommandSourceStack> mobTraitRank(MobTraitRankCommand cmd) {
        return ctx -> {
            int rank = (Integer)ctx.getArgument("rank", Integer.class);
            Holder.Reference trait = LHMobCommands.resolveKey((CommandContext<CommandSourceStack>)ctx, "trait", LHTraits.TRAITS.key(), ERR_INVALID_NAME);
            Collection list = EntityArgument.getEntities((CommandContext)ctx, (String)"targets");
            int count = LHMobCommands.iterate(list, (le, cap) -> cmd.run((LivingEntity)le, (MobTraitCap)((Object)((Object)cap)), (MobTrait)((Object)((Object)((Object)trait.value()))), rank));
            LHMobCommands.printCompletion((CommandSourceStack)ctx.getSource(), count);
            return 0;
        };
    }

    private static int iterate(Collection<? extends Entity> list, BiPredicate<LivingEntity, MobTraitCap> task) {
        int count = 0;
        for (Entity entity : list) {
            MobTraitCap cap;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)entity;
            Optional opt = ((GeneralCapabilityHolder)LHMiscs.MOB.type()).getExisting((IAttachmentHolder)le);
            if (opt.isEmpty() || !task.test(le, cap = (MobTraitCap)((Object)opt.get()))) continue;
            ++count;
        }
        return count;
    }

    private static void printCompletion(CommandSourceStack ctx, int count) {
        if (count > 0) {
            ctx.sendSystemMessage((Component)LangData.COMMAND_MOB_SUCCEED.get(count));
        } else {
            ctx.sendSystemMessage((Component)LangData.COMMAND_PLAYER_FAIL.get(new Object[0]).withStyle(ChatFormatting.RED));
        }
    }

    private static <T> ResourceKey<T> getRegistryKey(CommandContext<CommandSourceStack> ctx, String name, ResourceKey<Registry<T>> reg, DynamicCommandExceptionType err) throws CommandSyntaxException {
        ResourceKey ans = (ResourceKey)ctx.getArgument(name, ResourceKey.class);
        Optional optional = ans.cast(reg);
        return (ResourceKey)optional.orElseThrow(() -> err.create((Object)ans));
    }

    private static <T> Registry<T> getRegistry(CommandContext<CommandSourceStack> ctx, ResourceKey<? extends Registry<T>> reg) {
        return ((CommandSourceStack)ctx.getSource()).getServer().registryAccess().registryOrThrow(reg);
    }

    private static <T> Holder.Reference<T> resolveKey(CommandContext<CommandSourceStack> ctx, String name, ResourceKey<Registry<T>> reg, DynamicCommandExceptionType err) throws CommandSyntaxException {
        ResourceKey ans = LHMobCommands.getRegistryKey(ctx, name, reg, err);
        return (Holder.Reference)LHMobCommands.getRegistry(ctx, reg).getHolder(ans).orElseThrow(() -> err.create((Object)ans.location()));
    }

    private static interface MobCommand {
        public boolean run(LivingEntity var1, MobTraitCap var2);
    }

    private static interface MobTraitCommand {
        public boolean run(LivingEntity var1, MobTraitCap var2, MobTrait var3);
    }

    private static interface MobTraitRankCommand {
        public boolean run(LivingEntity var1, MobTraitCap var2, MobTrait var3, int var4);
    }

    private static interface MobLevelCommand {
        public boolean run(LivingEntity var1, MobTraitCap var2, int var3);
    }
}

