/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.capability.mob;

import dev.xkmc.l2hostility.content.capability.mob.MasterData;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@SerialClass
public class MinionData {
    @SerialField
    public UUID uuid;
    @SerialField
    public int id;
    @SerialField
    public double linkDistance;
    @SerialField
    public boolean protectMaster;
    @SerialField
    public boolean discardOnUnlink;
    @Nullable
    public Mob master;

    public boolean tick(LivingEntity mob) {
        Level level = mob.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (this.master == null) {
                e = sl.getEntity(this.uuid);
                if (e instanceof Mob) {
                    Mob mas;
                    this.master = mas = (Mob)e;
                } else if (this.discardOnUnlink) {
                    mob.discard();
                }
            }
            if (this.master != null && (double)this.master.distanceTo((Entity)mob) > this.linkDistance) {
                BlockPos next = MasterData.getRandomPos(sl, mob.getType(), (LivingEntity)this.master, (int)(this.linkDistance * 0.5), 16);
                if (next != null) {
                    mob.moveTo(Vec3.atCenterOf((Vec3i)next));
                } else if (this.discardOnUnlink) {
                    mob.discard();
                }
            }
        } else {
            Mob mas;
            if (this.master == null && (e = mob.level().getEntity(this.id)) instanceof Mob && (mas = (Mob)e).getUUID().equals(this.uuid)) {
                this.master = mas;
            }
            if (this.master != null && this.id != this.master.getId()) {
                this.id = this.master.getId();
                return true;
            }
        }
        return false;
    }

    public MinionData init(Mob mob, EntityConfig.Minion config) {
        this.uuid = mob.getUUID();
        this.id = mob.getId();
        this.linkDistance = config.linkDistance();
        this.protectMaster = config.protectMaster();
        this.discardOnUnlink = config.discardOnUnlink();
        this.master = mob;
        return this;
    }
}

