/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.capability.mob;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.chunk.RegionalDifficultyModifier;
import dev.xkmc.l2hostility.content.capability.mob.MinionData;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.content.traits.legendary.MasterTrait;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

@SerialClass
public class MasterData {
    @SerialField
    public ArrayList<Minion> data = new ArrayList();
    @SerialField(toClient=false)
    private final LinkedHashMap<EntityType<?>, Data> map = new LinkedHashMap();

    @Nullable
    public static BlockPos getRandomPos(ServerLevel sl, EntityType<?> type, LivingEntity mob, int r, int round) {
        BlockPos pos = mob.blockPosition();
        Vec3 eye = mob.getEyePosition();
        RandomSource rand = mob.getRandom();
        for (int i = 0; i < round; ++i) {
            Vec3 e;
            BlockHitResult bhit;
            BlockPos p = pos.offset(rand.nextInt(0, r * 2 + 1) - r, rand.nextInt(0, 3), rand.nextInt(0, r * 2 + 1) - r);
            if (!sl.noCollision(type.getSpawnAABB((double)p.getX(), (double)p.getY(), (double)p.getZ())) || (bhit = sl.clip(new ClipContext(eye, e = Vec3.atBottomCenterOf((Vec3i)p).add(0.0, (double)(type.getHeight() / 2.0f), 0.0), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.empty()))).getType() != HitResult.Type.MISS) continue;
            return p;
        }
        return null;
    }

    public boolean tick(MobTraitCap cap, Mob mob) {
        EntityConfig.MasterConfig config = MasterTrait.getConfig(mob.getType());
        if (config == null) {
            return false;
        }
        for (EntityConfig.Minion minion : config.minions()) {
            this.map.computeIfAbsent(minion.type(), k -> new Data()).setup(minion);
        }
        boolean updated = this.data.removeIf(e -> {
            e.tick(mob);
            if (e.minion == null) {
                return !mob.level().isClientSide();
            }
            Data ent = this.map.get(e.minion.getType());
            if (ent != null) {
                ++ent.count;
            }
            return false;
        });
        if (!mob.level().isClientSide()) {
            for (Minion minion : this.data) {
                if (minion.minion == null) continue;
                if (minion.minion.getTarget() == null && mob.getTarget() != null) {
                    minion.minion.setTarget(mob.getTarget());
                }
                if (minion.id == minion.minion.getId()) continue;
                minion.id = minion.minion.getId();
                updated = true;
            }
        }
        for (Data data : this.map.values()) {
            if (data.count >= data.config.maxCount() || data.cooldown <= 0) continue;
            --data.cooldown;
        }
        Level level = mob.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (mob.getTarget() != null && mob.getTarget().isAlive() && this.data.size() < config.maxTotalCount() && mob.tickCount % config.spawnInterval() == 0) {
                for (Data e4 : this.map.values()) {
                    Minion nd;
                    if (e4.cooldown > 0 || this.data.size() >= config.maxTotalCount() || e4.count >= e4.config.maxCount() || cap.getLevel() < e4.config.minLevel() || (nd = e4.spawn(cap, serverLevel, mob)) == null) continue;
                    this.data.add(nd);
                    e4.cooldown = e4.config.cooldown();
                    return true;
                }
            }
        }
        return updated;
    }

    @SerialClass
    public static class Data {
        private EntityConfig.Minion config;
        private int count;
        @SerialField
        public int cooldown;

        public void setup(EntityConfig.Minion e) {
            this.config = e;
            this.count = 0;
        }

        @Nullable
        public Minion spawn(MobTraitCap parent, ServerLevel sl, Mob mob) {
            Mob m;
            block6: {
                block5: {
                    int r = this.config.spawnRange();
                    BlockPos target = MasterData.getRandomPos(sl, this.config.type(), (LivingEntity)mob, r / 2, 16);
                    if (target == null) {
                        return null;
                    }
                    Entity e = this.config.type().create(sl, null, target, MobSpawnType.MOB_SUMMONED, false, false);
                    if (!(e instanceof Mob)) break block5;
                    m = (Mob)e;
                    if (((GeneralCapabilityHolder)LHMiscs.MOB.type()).isProper((IAttachmentHolder)m)) break block6;
                }
                return null;
            }
            MobTraitCap cap = (MobTraitCap)((GeneralCapabilityHolder)LHMiscs.MOB.type()).getOrCreate((IAttachmentHolder)m);
            RegionalDifficultyModifier diff = (p, c) -> {
                if (this.config.copyLevel()) {
                    c.base = parent.getLevel();
                } else {
                    ChunkDifficulty.at((Level)sl, p).ifPresent(x -> x.modifyInstance(p, c));
                }
                if (this.config.copyTrait()) {
                    cap.traits.putAll(parent.traits);
                    c.delegateTrait();
                }
            };
            if (this.config.traits() != null) {
                cap.setConfigCache(this.config.traits());
            }
            cap.minion = true;
            cap.asMinion = new MinionData().init(mob, this.config);
            cap.init((Level)sl, (LivingEntity)m, diff);
            m.setTarget(mob.getTarget());
            sl.addFreshEntity((Entity)m);
            Minion ans = new Minion();
            ans.minion = m;
            ans.uuid = m.getUUID();
            ans.id = m.getId();
            return ans;
        }
    }

    @SerialClass
    public static class Minion {
        @SerialField(toClient=true)
        public UUID uuid;
        @SerialField(toClient=true)
        public int id;
        public Mob minion;

        public void tick(Mob mob) {
            Mob m;
            Entity e;
            Level level = mob.level();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                if (this.minion == null && (e = sl.getEntity(this.uuid)) instanceof Mob) {
                    Mob m2;
                    this.minion = m2 = (Mob)e;
                }
                if (this.minion != null && !this.minion.isAlive()) {
                    this.minion = null;
                }
            } else if (this.minion == null && (e = mob.level().getEntity(this.id)) instanceof Mob && (m = (Mob)e).getUUID().equals(this.uuid)) {
                this.minion = m;
            }
        }
    }
}

