/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.content.capability.chunk;

import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2core.capability.attachment.GeneralCapabilityTemplate;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkCapHolder;
import dev.xkmc.l2hostility.content.capability.chunk.SectionDifficulty;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import dev.xkmc.l2serial.serialization.marker.SerialClass;
import dev.xkmc.l2serial.serialization.marker.SerialField;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

@SerialClass
public class ChunkDifficulty
extends GeneralCapabilityTemplate<LevelChunk, ChunkDifficulty> {
    private ChunkStage stage = ChunkStage.PRE_INIT;
    @SerialField
    protected SectionDifficulty[] sections;

    public static Optional<ChunkCapHolder> at(Level level, BlockPos pos) {
        return ChunkDifficulty.at(level, pos.getX() >> 4, pos.getZ() >> 4);
    }

    public static Optional<ChunkCapHolder> at(Level level, int x, int z) {
        ChunkAccess chunk = level.getChunk(x, z, ChunkStatus.CARVERS, false);
        if (chunk instanceof ImposterProtoChunk) {
            ImposterProtoChunk im = (ImposterProtoChunk)chunk;
            chunk = im.getWrapped();
        }
        if (chunk instanceof LevelChunk) {
            LevelChunk c = (LevelChunk)chunk;
            return Optional.of(new ChunkCapHolder(c, (ChunkDifficulty)((GeneralCapabilityHolder)LHMiscs.CHUNK.type()).getOrCreate((IAttachmentHolder)c)));
        }
        return Optional.empty();
    }

    protected void check(LevelChunk chunk) {
        int i;
        int size = chunk.getLevel().getSectionsCount();
        if (this.sections != null && this.sections.length == size && this.stage != ChunkStage.PRE_INIT) {
            return;
        }
        this.stage = ChunkStage.INIT;
        if (this.sections == null || this.sections.length != size) {
            this.sections = new SectionDifficulty[size];
            for (i = 0; i < size; ++i) {
                this.sections[i] = new SectionDifficulty();
                this.sections[i].index = chunk.getMinSection() + i;
            }
        }
        for (i = 0; i < size; ++i) {
            this.sections[i].section = chunk.getSection(i);
        }
    }

    public static enum ChunkStage {
        PRE_INIT,
        INIT;

    }
}

