/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.compat.gateway;

import com.mojang.datafixers.util.Pair;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.event.GateEvent;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.xkmc.l2core.capability.attachment.GeneralCapabilityHolder;
import dev.xkmc.l2hostility.compat.gateway.WaveData;
import dev.xkmc.l2hostility.compat.gateway.WaveId;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkCapHolder;
import dev.xkmc.l2hostility.content.capability.chunk.ChunkDifficulty;
import dev.xkmc.l2hostility.content.capability.mob.MobTraitCap;
import dev.xkmc.l2hostility.content.config.EntityConfig;
import dev.xkmc.l2hostility.init.L2Hostility;
import dev.xkmc.l2hostility.init.data.LHConfig;
import dev.xkmc.l2hostility.init.registrate.LHMiscs;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.attachment.IAttachmentHolder;

public class GatewayToEternityCompat {
    private static final ThreadLocal<Pair<GatewayEntity, WaveData>> CURRENT = new ThreadLocal();

    @SubscribeEvent
    public static void onSpawn(GateEvent.WaveEntitySpawned event) {
        WaveData data;
        Pair<GatewayEntity, WaveData> prev = CURRENT.get();
        GatewayEntity gate = event.getEntity();
        int wave = event.getEntity().getWave();
        ResourceLocation rl = GatewayRegistry.INSTANCE.getKey((CodecProvider)event.getEntity().getGateway());
        if (rl == null) {
            return;
        }
        WaveId id = new WaveId(rl, wave);
        if (prev == null || gate != prev.getFirst() || !((WaveData)prev.getSecond()).id.equals(id)) {
            data = new WaveData(id);
            CURRENT.set((Pair<GatewayEntity, WaveData>)Pair.of((Object)gate, (Object)data));
        } else {
            data = (WaveData)prev.getSecond();
        }
        EntityConfig.Config config = ((EntityConfig)L2Hostility.ENTITY.getMerged()).get(event.getWaveEntity().getType(), rl, WaveData.class, data);
        if (config != null) {
            GatewayToEternityCompat.initMob(event.getWaveEntity(), config);
        }
    }

    private static void initMob(LivingEntity mob, EntityConfig.Config config) {
        if (((GeneralCapabilityHolder)LHMiscs.MOB.type()).isProper((IAttachmentHolder)mob)) {
            Optional<ChunkCapHolder> opt;
            MobTraitCap cap = (MobTraitCap)((GeneralCapabilityHolder)LHMiscs.MOB.type()).getOrCreate((IAttachmentHolder)mob);
            if (!mob.level().isClientSide() && !cap.isInitialized() && (opt = ChunkDifficulty.at(mob.level(), mob.blockPosition())).isPresent()) {
                cap.setConfigCache(config);
                cap.init(mob.level(), mob, opt.get());
                cap.dropRate = (Double)LHConfig.SERVER.dropRateFromSpawner.get();
            }
        }
    }
}

