/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2hostility.compat.curios;

import com.google.common.collect.Multimap;
import dev.xkmc.l2hostility.compat.curios.EntitySlotAccess;
import dev.xkmc.l2hostility.compat.curios.EquipmentSlotAccess;
import dev.xkmc.l2hostility.init.data.LHConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CurioCompat {
    private static final ResourceLocation DUMMY_ID = ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"dummy_id");

    public static boolean hasItemInCurioOrSlot(LivingEntity player, Item item) {
        for (EquipmentSlot e : EquipmentSlot.values()) {
            if (!player.getItemBySlot(e).is(item)) continue;
            return true;
        }
        return CurioCompat.hasItemInCurio(player, item);
    }

    public static boolean hasItemInCurioChecked(LivingEntity le, Item item) {
        if (((Boolean)LHConfig.SERVER.enableCurioCheckFilter.get()).booleanValue() && (le instanceof Enemy || le instanceof Animal)) {
            return false;
        }
        return CurioCompat.hasItemInCurio(le, item);
    }

    public static boolean hasItemInCurio(LivingEntity player, Item item) {
        if (ModList.get().isLoaded("curios")) {
            return CurioCompat.hasItemImpl(player, item);
        }
        return false;
    }

    public static List<ItemStack> getItems(LivingEntity player, Predicate<ItemStack> pred) {
        ArrayList<ItemStack> ans = new ArrayList<ItemStack>();
        for (EquipmentSlot e : EquipmentSlot.values()) {
            ItemStack stack = player.getItemBySlot(e);
            if (!pred.test(stack)) continue;
            ans.add(stack);
        }
        if (ModList.get().isLoaded("curios")) {
            CurioCompat.getItemImpl(ans, player, pred);
        }
        return ans;
    }

    public static List<EntitySlotAccess> getItemAccess(LivingEntity player) {
        ArrayList<EntitySlotAccess> ans = new ArrayList<EntitySlotAccess>();
        for (EquipmentSlot e : EquipmentSlot.values()) {
            ans.add(new EquipmentSlotAccess(player, e));
        }
        if (ModList.get().isLoaded("curios")) {
            CurioCompat.getItemAccessImpl(ans, player);
        }
        return ans;
    }

    @Nullable
    public static EntitySlotAccess decode(String id, LivingEntity le) {
        try {
            String[] strs = id.split("/");
            if (strs[0].equals("equipment")) {
                return new EquipmentSlotAccess(le, EquipmentSlot.byName((String)strs[1]));
            }
            if (strs[0].equals("curios")) {
                Optional opt = CuriosApi.getCuriosInventory((LivingEntity)le);
                if (opt.isEmpty()) {
                    return null;
                }
                Optional handler = ((ICuriosItemHandler)opt.get()).getStacksHandler(strs[1]);
                if (handler.isEmpty()) {
                    return null;
                }
                int index = strs.length == 2 ? 0 : Integer.parseInt(strs[2]);
                return new CurioSlotAccess(le, ((ICurioStacksHandler)handler.get()).getStacks(), index, strs[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean hasItemImpl(LivingEntity player, Item item) {
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)player);
        return opt.isPresent() && ((ICuriosItemHandler)opt.get()).isEquipped(item);
    }

    private static void getItemImpl(List<ItemStack> list, LivingEntity player, Predicate<ItemStack> pred) {
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (opt.isEmpty()) {
            return;
        }
        for (ICurioStacksHandler e : ((ICuriosItemHandler)opt.get()).getCurios().values()) {
            for (int i = 0; i < e.getStacks().getSlots(); ++i) {
                ItemStack stack = e.getStacks().getStackInSlot(i);
                if (!pred.test(stack)) continue;
                list.add(stack);
            }
        }
    }

    private static void getItemAccessImpl(List<EntitySlotAccess> list, LivingEntity player) {
        Optional opt = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (opt.isEmpty()) {
            return;
        }
        for (ICurioStacksHandler e : ((ICuriosItemHandler)opt.get()).getCurios().values()) {
            for (int i = 0; i < e.getStacks().getSlots(); ++i) {
                list.add(new CurioSlotAccess(player, e.getStacks(), i, e.getIdentifier()));
            }
        }
    }

    public static boolean isSlotAdder(EntitySlotAccess access) {
        if (!(access instanceof CurioSlotAccess)) {
            return false;
        }
        CurioSlotAccess slot = (CurioSlotAccess)access;
        ItemStack stack = access.get();
        Optional opt = CuriosApi.getCurio((ItemStack)stack);
        if (opt.isEmpty()) {
            return false;
        }
        Multimap multimap = CuriosApi.getAttributeModifiers((SlotContext)new SlotContext(slot.id, slot.player, 0, false, true), (ResourceLocation)DUMMY_ID, (ItemStack)stack);
        for (Holder e : multimap.keySet()) {
            if (!(e.value() instanceof SlotAttribute)) continue;
            return true;
        }
        return false;
    }

    private record CurioSlotAccess(LivingEntity player, IDynamicStackHandler handler, int slot, String id) implements EntitySlotAccess
    {
        @Override
        public ItemStack get() {
            if (this.handler.getSlots() <= this.slot) {
                return ItemStack.EMPTY;
            }
            return this.handler.getStackInSlot(this.slot);
        }

        @Override
        public void set(ItemStack stack) {
            if (this.handler.getSlots() <= this.slot) {
                LivingEntity livingEntity = this.player;
                if (livingEntity instanceof Player) {
                    Player pl = (Player)livingEntity;
                    pl.getInventory().placeItemBackInInventory(stack);
                } else {
                    this.player.spawnAtLocation(stack);
                }
            } else {
                this.handler.setStackInSlot(this.slot, stack);
            }
        }

        @Override
        public String getID() {
            return "curios/" + this.id + "/" + this.slot;
        }
    }
}

