/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.mixin;

import dev.xkmc.l2weaponry.content.item.base.BaseShieldItem;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    @Deprecated
    protected PlayerMixin(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(at={@At(value="HEAD")}, method={"hurtCurrentlyUsedShield"})
    public void l2weaponry_hurtCurrentlyUsedShield_customShield(float pDamage, CallbackInfo ci) {
        Item item = this.useItem.getItem();
        if (item instanceof BaseShieldItem) {
            BaseShieldItem shield = (BaseShieldItem)item;
            Player player = (Player)this;
            int amount = (int)Math.floor(pDamage);
            shield.takeDamage(this.useItem, player, amount);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"blockUsingShield"}, cancellable=true)
    public void l2weaponry_blockUsingShield_customShield(LivingEntity pEntity, CallbackInfo ci) {
        Player player = (Player)this;
        ItemStack stack = player.getUseItem();
        Item item = stack.getItem();
        if (item instanceof BaseShieldItem) {
            BaseShieldItem shield = (BaseShieldItem)item;
            double strength = shield.reflect(stack, player, pEntity);
            pEntity.knockback(strength, player.getX() - pEntity.getX(), player.getZ() - pEntity.getZ());
            if (pEntity.canDisableShield()) {
                player.disableShield();
            }
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"disableShield"}, cancellable=true)
    public void l2weaponry_disableShield_customShield(CallbackInfo ci) {
        Player player = (Player)this;
        ItemStack stack = player.getUseItem();
        Item item = stack.getItem();
        if (item instanceof BaseShieldItem) {
            BaseShieldItem shield = (BaseShieldItem)item;
            int cd = shield.damageShield(player, stack, 1.0);
            if (cd > 0) {
                player.getCooldowns().addCooldown(player.getUseItem().getItem(), cd);
                player.stopUsingItem();
                player.level().broadcastEntityEvent((Entity)player, (byte)30);
            }
            ci.cancel();
        }
    }
}

