/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.init.materials;

import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2damagetracker.contents.materials.api.ITool;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2damagetracker.contents.materials.vanilla.RawToolFactory;
import dev.xkmc.l2damagetracker.init.L2DamageTracker;
import dev.xkmc.l2weaponry.content.item.types.BattleAxeItem;
import dev.xkmc.l2weaponry.content.item.types.ClawItem;
import dev.xkmc.l2weaponry.content.item.types.DaggerItem;
import dev.xkmc.l2weaponry.content.item.types.HammerItem;
import dev.xkmc.l2weaponry.content.item.types.JavelinItem;
import dev.xkmc.l2weaponry.content.item.types.MacheteItem;
import dev.xkmc.l2weaponry.content.item.types.NunchakuItem;
import dev.xkmc.l2weaponry.content.item.types.PlateShieldItem;
import dev.xkmc.l2weaponry.content.item.types.RoundShieldItem;
import dev.xkmc.l2weaponry.content.item.types.ScytheItem;
import dev.xkmc.l2weaponry.content.item.types.SpearItem;
import dev.xkmc.l2weaponry.content.item.types.ThrowingAxeItem;
import dev.xkmc.l2weaponry.init.L2Weaponry;
import dev.xkmc.l2weaponry.init.data.LWTagGen;
import dev.xkmc.l2weaponry.init.materials.LegendaryTool;
import dev.xkmc.l2weaponry.init.materials.LegendaryToolFactory;
import dev.xkmc.l2weaponry.init.registrate.LWEnchantments;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public enum LWToolTypes implements ITool
{
    CLAW(LWTagGen.CLAW, ClawItem::new, 0.7f, 3.0f, -1.0f, "claw_base", new DefaultEnch((ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE, 2)),
    DAGGER(LWTagGen.DAGGER, DaggerItem::new, 0.7f, 4.0f, -1.0f, "dagger", new DefaultEnch((ResourceKey<Enchantment>)LWEnchantments.INSTANT_THROWING.id(), 1)),
    MACHETE(LWTagGen.MACHETE, MacheteItem::new, 1.2f, 1.0f, 0.0f, "machete", new DefaultEnch((ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE, 1)),
    THROWING_AXE(LWTagGen.THROWING_AXE, ThrowingAxeItem::new, 1.4f, 1.0f, -0.5f, "throwing_axe", new DefaultEnch((ResourceKey<Enchantment>)Enchantments.LOYALTY, 1)),
    HAMMER(LWTagGen.HAMMER, HammerItem::new, 2.0f, 0.7f, 0.0f, "hammer", new DefaultEnch((ResourceKey<Enchantment>)LCEnchantments.CUBIC.id(), 1)),
    BATTLE_AXE(LWTagGen.BATTLE_AXE, BattleAxeItem::new, 2.0f, 0.7f, 0.0f, "battle_axe", new DefaultEnch((ResourceKey<Enchantment>)LCEnchantments.TREE.id(), 1)),
    SCYTHE(LWTagGen.SCYTHE, ScytheItem::new, 1.5f, 0.9f, 1.0f, "scythe", new DefaultEnch((ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE, 3)),
    SPEAR(LWTagGen.SPEAR, SpearItem::new, 1.0f, 1.0f, 2.0f, "long_weapon", new DefaultEnch((ResourceKey<Enchantment>)LCEnchantments.PLANE.id(), 1)),
    JAVELIN(LWTagGen.JAVELIN, JavelinItem::new, 1.0f, 1.2f, 2.0f, "long_weapon", new DefaultEnch((ResourceKey<Enchantment>)LCEnchantments.DRILL.id(), 1)),
    ROUND_SHIELD(LWTagGen.ROUND_SHIELD, RoundShieldItem::new, 5.0f, 0.0f, 0.0f, new DefaultEnch[0]),
    PLATE_SHIELD(LWTagGen.PLATE_SHIELD, PlateShieldItem::new, 20.0f, 0.0f, 0.0f, new DefaultEnch[0]),
    NUNCHAKU(LWTagGen.NUNCHAKU, NunchakuItem::new, 0.5f, 4.0f, 0.0f, "nunchaku", new DefaultEnch[0]);

    public final TagKey<Item> tag;
    private final RawToolFactory fac;
    private final float damage;
    private final float speed;
    private final float range;
    private final String customModel;
    private final List<DefaultEnch> enchs;

    private LWToolTypes(TagKey<Item> tag, RawToolFactory fac, float damage, @Nullable float speed, float range, String customModel, DefaultEnch ... enchs) {
        this.tag = tag;
        this.fac = fac;
        this.damage = damage;
        this.speed = speed;
        this.range = range;
        this.customModel = customModel;
        this.enchs = List.of(enchs);
    }

    private LWToolTypes(TagKey<Item> tag, RawToolFactory fac, float damage, float speed, float range, DefaultEnch ... enchs) {
        this(tag, fac, damage, speed, range, (String)null, enchs);
    }

    public void configure(ItemAttributeModifiers.Builder builder, int dmg, float speed) {
        ResourceLocation id = L2Weaponry.loc(this.name().toLowerCase());
        if (this == ROUND_SHIELD) {
            builder.add(LWItems.SHIELD_DEFENSE.holder(), new AttributeModifier(id, (double)dmg, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND);
        } else if (this == PLATE_SHIELD) {
            builder.add(LWItems.SHIELD_DEFENSE.holder(), new AttributeModifier(id, (double)dmg, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(Math.round((double)dmg * 0.035) - 1L), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, 16.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(id, -0.95, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.MAINHAND);
            builder.add(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(id, 4.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            builder.add(LWItems.REFLECT_TIME.holder(), new AttributeModifier(id, 20.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            builder.add(L2DamageTracker.CRIT_DMG.holder(), new AttributeModifier(id, 1.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        } else if (this == BATTLE_AXE || this == HAMMER) {
            builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(dmg - 1), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            float raw_speed = speed + (float)dmg;
            float reduce = 1.0f - (float)Math.round(speed / raw_speed * 100.0f) * 0.01f;
            raw_speed = speed / (1.0f - reduce);
            builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)(raw_speed - 4.0f), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
            builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(id, (double)(-reduce), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.MAINHAND);
        } else {
            if (this.range != 0.0f) {
                AttributeModifier attr = new AttributeModifier(id, (double)this.range, AttributeModifier.Operation.ADD_VALUE);
                builder.add(Attributes.ENTITY_INTERACTION_RANGE, attr, EquipmentSlotGroup.MAINHAND);
                if (this.range > 0.0f) {
                    builder.add(Attributes.BLOCK_INTERACTION_RANGE, attr, EquipmentSlotGroup.MAINHAND);
                }
            }
            super.configure(builder, dmg, speed);
        }
    }

    public int getDamage(int base_damage) {
        return Math.round((float)base_damage * this.damage);
    }

    public float getAtkSpeed(float base_speed) {
        return (float)Math.round(base_speed * this.speed * 10.0f) * 0.1f;
    }

    public Item create(Tier tier, Item.Properties properties, ExtraToolConfig extraToolConfig) {
        return this.fac.get(tier, properties, extraToolConfig);
    }

    @Nullable
    public String customModel() {
        return this.customModel;
    }

    public <T extends Item> LegendaryTool<T> legendary(LegendaryToolFactory<T> fac) {
        return new LegendaryTool<T>(this, fac);
    }

    public List<DefaultEnch> getEnchs() {
        return this.enchs;
    }

    public boolean hasIcon() {
        return this == BATTLE_AXE || this == SCYTHE || this == SPEAR || this == JAVELIN;
    }

    public record DefaultEnch(ResourceKey<Enchantment> key, int lv) {
    }
}

