/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.init.materials;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2complements.init.materials.LCMats;
import dev.xkmc.l2damagetracker.contents.materials.api.IMatToolType;
import dev.xkmc.l2damagetracker.contents.materials.vanilla.VanillaMats;
import dev.xkmc.l2weaponry.init.materials.ILWToolMats;
import dev.xkmc.l2weaponry.init.materials.LWToolTypes;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import org.jetbrains.annotations.Nullable;

public enum LWToolMats implements ILWToolMats
{
    IRON((IMatToolType)new VanillaMats(Tiers.IRON), Items.IRON_NUGGET, Items.IRON_INGOT, Items.IRON_BLOCK, false),
    GOLD((IMatToolType)new VanillaMats(Tiers.GOLD), Items.GOLD_NUGGET, Items.GOLD_INGOT, Items.GOLD_BLOCK, false),
    DIAMOND((IMatToolType)new VanillaMats(Tiers.DIAMOND), Items.AIR, Items.DIAMOND, Items.DIAMOND_BLOCK, false),
    NETHERITE((IMatToolType)new VanillaMats(Tiers.NETHERITE), Items.AIR, Items.NETHERITE_INGOT, Items.NETHERITE_BLOCK, true),
    TOTEMIC_GOLD(LCMats.TOTEMIC_GOLD, false),
    POSEIDITE(LCMats.POSEIDITE, false),
    SHULKERATE(LCMats.SHULKERATE, false),
    SCULKIUM(LCMats.SCULKIUM, true),
    ETERNIUM(LCMats.ETERNIUM, true);

    public final IMatToolType type;
    private final Supplier<Item> nugget;
    private final Supplier<Item> ingot;
    private final Supplier<Item> block;
    private final Supplier<Item> toolIngot;
    private final Supplier<Item> handle;
    final boolean fireRes;

    private LWToolMats(IMatToolType type, Item nugget, Item ingot, Item block, boolean fireRes) {
        this.type = type;
        this.nugget = () -> nugget;
        this.ingot = () -> ingot;
        this.block = () -> block;
        this.fireRes = fireRes;
        this.toolIngot = this.ingot;
        this.handle = LWItems.HANDLE;
    }

    private LWToolMats(LCMats type, boolean fireRes) {
        this.type = type;
        this.nugget = () -> ((LCMats)type).getNugget();
        this.ingot = () -> ((LCMats)type).getIngot();
        this.block = () -> type.getBlock().asItem();
        this.toolIngot = () -> ((LCMats)type).getToolIngot();
        this.handle = () -> ((LCMats)type).getToolStick();
        this.fireRes = fireRes;
    }

    @Override
    public Item getIngot() {
        return this.ingot.get();
    }

    public Item getToolIngot() {
        return this.toolIngot.get();
    }

    @Override
    public Item getStick() {
        return this.handle.get();
    }

    @Override
    @Nullable
    public Pair<ILWToolMats, Item> getBaseUpgrade() {
        return this == NETHERITE ? Pair.of((Object)DIAMOND, (Object)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE) : null;
    }

    @Override
    public boolean is3D(LWToolTypes type) {
        return type == LWToolTypes.BATTLE_AXE || type == LWToolTypes.HAMMER || type == LWToolTypes.SPEAR;
    }

    @Override
    public Item getBlock() {
        return this.block.get();
    }

    @Override
    public Item getTool(LWToolTypes type) {
        return (Item)LWItems.GEN_ITEM[this.ordinal()][type.ordinal()].get();
    }

    public Item getNugget() {
        return this.nugget.get();
    }

    @Override
    public IMatToolType type() {
        return this.type;
    }

    @Override
    public boolean fireRes() {
        return this.fireRes;
    }
}

