/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.init.materials;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import dev.xkmc.l2core.serial.configval.BooleanValueCondition;
import dev.xkmc.l2core.serial.recipe.ConditionalRecipeWrapper;
import dev.xkmc.l2core.serial.recipe.DataRecipeWrapper;
import dev.xkmc.l2core.util.ConfigInit;
import dev.xkmc.l2damagetracker.contents.materials.api.IMatToolType;
import dev.xkmc.l2weaponry.init.L2Weaponry;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import dev.xkmc.l2weaponry.init.materials.LWToolTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.loaders.ItemLayerModelBuilder;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public interface ILWToolMats {
    public String name();

    public IMatToolType type();

    public boolean fireRes();

    public Item getTool(LWToolTypes var1);

    public Item getIngot();

    public Item getBlock();

    public Item getStick();

    default public Item getChain() {
        return Items.CHAIN;
    }

    default public void addEnchants(HolderLookup.Provider pvd, List<LWToolTypes.DefaultEnch> list, LWToolTypes type) {
    }

    default public void saveRecipe(Supplier<ShapedRecipeBuilder> b, RegistrateRecipeProvider pvd, LWToolTypes type, ResourceLocation id) {
        ItemStack stack = this.getToolEnchanted(pvd.getProvider(), type);
        if (!stack.isComponentsPatchEmpty()) {
            b.get().save(DataRecipeWrapper.of((RecipeOutput)this.getProvider(pvd, new ICondition[]{BooleanValueCondition.of((ConfigInit)LWConfig.RECIPE, x -> x.defaultEnchantmentOnWeapons, (boolean)true)}), (ItemStack)stack), id.withSuffix("_enchanted"));
            b.get().save(this.getProvider(pvd, new ICondition[]{BooleanValueCondition.of((ConfigInit)LWConfig.RECIPE, x -> x.defaultEnchantmentOnWeapons, (boolean)false)}), id);
        } else {
            b.get().save(this.getProvider(pvd, new ICondition[0]), id);
        }
    }

    default public String englishName() {
        return this.name();
    }

    default public ItemModelBuilder model(LWToolTypes type, ItemModelBuilder b) {
        if (this.emissive() && type != LWToolTypes.ROUND_SHIELD && type != LWToolTypes.PLATE_SHIELD) {
            return (ItemModelBuilder)((ItemLayerModelBuilder)b.customLoader(ItemLayerModelBuilder::begin)).emissive(15, 15, new int[]{0}).end();
        }
        return b;
    }

    default public boolean emissive() {
        return false;
    }

    default public RecipeOutput getProvider(RegistrateRecipeProvider pvd, ICondition ... cond) {
        return cond.length == 0 ? pvd : ConditionalRecipeWrapper.of((RecipeOutput)pvd, (ICondition[])cond);
    }

    default public boolean hasTool(LWToolTypes type) {
        return true;
    }

    default public String prefix() {
        return "";
    }

    default public boolean isOptional() {
        return false;
    }

    @Nullable
    default public Pair<ILWToolMats, Item> getBaseUpgrade() {
        return null;
    }

    default public boolean is3D(LWToolTypes type) {
        return false;
    }

    default public ItemStack getToolEnchanted(HolderLookup.Provider pvd, LWToolTypes type) {
        ArrayList<LWToolTypes.DefaultEnch> enchs = new ArrayList<LWToolTypes.DefaultEnch>(type.getEnchs());
        this.addEnchants(pvd, enchs, type);
        ItemStack stack = this.getTool(type).getDefaultInstance();
        if (!enchs.isEmpty()) {
            for (LWToolTypes.DefaultEnch e : enchs) {
                stack.enchant(pvd.holderOrThrow(e.key()), e.lv());
            }
        }
        return stack;
    }

    default public TagKey<Item> tag() {
        return ItemTags.create((ResourceLocation)L2Weaponry.loc("material/" + this.name().toLowerCase(Locale.ROOT)));
    }
}

