/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.init.data;

import com.mojang.datafixers.util.Pair;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import dev.xkmc.l2complements.content.enchantment.core.EnchantmentRecipeBuilder;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.materials.LCMats;
import dev.xkmc.l2complements.init.registrate.LCItems;
import dev.xkmc.l2core.serial.configval.BooleanValueCondition;
import dev.xkmc.l2core.serial.ingredients.EnchantmentIngredient;
import dev.xkmc.l2core.serial.recipe.AbstractSmithingRecipe;
import dev.xkmc.l2core.util.ConfigInit;
import dev.xkmc.l2weaponry.compat.CompatDispatch;
import dev.xkmc.l2weaponry.init.L2Weaponry;
import dev.xkmc.l2weaponry.init.materials.ILWToolMats;
import dev.xkmc.l2weaponry.init.materials.LWToolMats;
import dev.xkmc.l2weaponry.init.materials.LWToolTypes;
import dev.xkmc.l2weaponry.init.registrate.LWEnchantments;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;

public class LWRecipeGen {
    private static String currentFolder = "";

    public static void genRecipe(RegistrateRecipeProvider pvd) {
        currentFolder = "misc/";
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((ShapedRecipeBuilder)new ShapedRecipeBuilder(RecipeCategory.MISC, (ItemLike)LWItems.HANDLE.get(), 2)).unlockedBy(arg_0, arg_1), Items.STICK).pattern(" SI").pattern("SIS").pattern("IS ").define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('I'), (ItemLike)Items.COPPER_INGOT).save((RecipeOutput)pvd, LWRecipeGen.getID((Item)LWItems.HANDLE.get()));
        currentFolder = "generated/";
        for (LWToolMats mat : LWToolMats.values()) {
            LWRecipeGen.tools(pvd, mat.getStick(), mat.getToolIngot(), mat);
            if (mat.getNugget() == Items.AIR) continue;
            currentFolder = "generated/recycle/";
            for (LWToolTypes type : LWToolTypes.values()) {
                if (!mat.hasTool(type)) continue;
                LWRecipeGen.smelting(pvd, mat.getTool(type), mat.getNugget(), 0.1f);
            }
        }
        for (CompatDispatch dispatch : CompatDispatch.LIST) {
            for (ILWToolMats mat : dispatch.values()) {
                LWRecipeGen.tools(pvd, mat.getStick(), mat.getIngot(), mat);
            }
            dispatch.regExtraRecipes(pvd);
        }
        currentFolder = "legendary/";
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((ShapedRecipeBuilder)new ShapedRecipeBuilder(RecipeCategory.COMBAT, (ItemLike)LWItems.STORM_JAVELIN.get(), 1)).unlockedBy(arg_0, arg_1), (Item)LCItems.GUARDIAN_EYE.get()).pattern("cds").pattern("wgd").pattern("jwc").define(Character.valueOf('d'), (ItemLike)LWToolMats.POSEIDITE.getTool(LWToolTypes.DAGGER)).define(Character.valueOf('j'), (ItemLike)LWToolMats.POSEIDITE.getTool(LWToolTypes.JAVELIN)).define(Character.valueOf('s'), (ItemLike)LWToolMats.POSEIDITE.getTool(LWToolTypes.SPEAR)).define(Character.valueOf('g'), (ItemLike)LCItems.GUARDIAN_EYE.get()).define(Character.valueOf('c'), EnchantmentIngredient.of((HolderLookup.Provider)pvd.getProvider(), (ResourceKey)Enchantments.CHANNELING, (int)1)).define(Character.valueOf('w'), (ItemLike)LCItems.STORM_CORE.get()).save((RecipeOutput)pvd, LWRecipeGen.getID((Item)LWItems.STORM_JAVELIN.get()));
        LWRecipeGen.smithing(pvd, LWToolMats.IRON.getTool(LWToolTypes.SPEAR), (Item)LCItems.HARD_ICE.get(), (Item)LWItems.FROZEN_SPEAR.get());
        LWRecipeGen.smithing(pvd, LWToolMats.NETHERITE.getTool(LWToolTypes.BATTLE_AXE), (Item)LCItems.SOUL_FLAME.get(), (Item)LWItems.FLAME_AXE.get());
        LWRecipeGen.smithing(pvd, LWToolMats.NETHERITE.getTool(LWToolTypes.HAMMER), (Item)LCItems.BLACKSTONE_CORE.get(), (Item)LWItems.BLACK_HAMMER.get());
        LWRecipeGen.smithing(pvd, LWToolMats.NETHERITE.getTool(LWToolTypes.THROWING_AXE), (Item)LCItems.BLACKSTONE_CORE.get(), (Item)LWItems.BLACK_AXE.get());
        LWRecipeGen.smithing(pvd, LWToolMats.NETHERITE.getTool(LWToolTypes.SCYTHE), (Item)LCItems.SOUL_FLAME.get(), (Item)LWItems.DEATH_SCYTHE.get());
        LWRecipeGen.smithing(pvd, LWToolMats.SHULKERATE.getTool(LWToolTypes.SPEAR), (Item)LCItems.VOID_EYE.get(), (Item)LWItems.ENDER_SPEAR.get());
        LWRecipeGen.smithing(pvd, LWToolMats.SHULKERATE.getTool(LWToolTypes.JAVELIN), (Item)LCItems.STORM_CORE.get(), (Item)LWItems.ENDER_JAVELIN.get());
        LWRecipeGen.smithing(pvd, LWToolMats.SHULKERATE.getTool(LWToolTypes.DAGGER), (Item)LCItems.VOID_EYE.get(), (Item)LWItems.ENDER_DAGGER.get());
        LWRecipeGen.smithing(pvd, LWToolMats.SHULKERATE.getTool(LWToolTypes.MACHETE), (Item)LCItems.STORM_CORE.get(), (Item)LWItems.ENDER_MACHETE.get());
        LWRecipeGen.smithing(pvd, LWToolMats.SCULKIUM.getTool(LWToolTypes.DAGGER), (Item)LCItems.RESONANT_FEATHER.get(), (Item)LWItems.ABYSS_DAGGER.get());
        LWRecipeGen.smithing(pvd, LWToolMats.SCULKIUM.getTool(LWToolTypes.MACHETE), (Item)LCItems.RESONANT_FEATHER.get(), (Item)LWItems.ABYSS_MACHETE.get());
        LWRecipeGen.smithing(pvd, LWToolMats.SCULKIUM.getTool(LWToolTypes.HAMMER), (Item)LCItems.RESONANT_FEATHER.get(), (Item)LWItems.ABYSS_HAMMER.get());
        LWRecipeGen.smithing(pvd, LWToolMats.SCULKIUM.getTool(LWToolTypes.BATTLE_AXE), (Item)LCItems.RESONANT_FEATHER.get(), (Item)LWItems.ABYSS_AXE.get());
        LWRecipeGen.smithing(pvd, LWToolMats.TOTEMIC_GOLD.getTool(LWToolTypes.CLAW), (Item)LCItems.CURSED_DROPLET.get(), (Item)LWItems.BLOOD_CLAW.get());
        LWRecipeGen.smithing(pvd, LWToolMats.TOTEMIC_GOLD.getTool(LWToolTypes.BATTLE_AXE), (Item)LCItems.LIFE_ESSENCE.get(), (Item)LWItems.HOLY_AXE.get());
        LWRecipeGen.smithing(pvd, LWToolMats.TOTEMIC_GOLD.getTool(LWToolTypes.HAMMER), (Item)LCItems.SUN_MEMBRANE.get(), (Item)LWItems.HOLY_HAMMER.get());
        LWRecipeGen.smithing(pvd, LWToolMats.ETERNIUM.getTool(LWToolTypes.CLAW), (Item)LCItems.SUN_MEMBRANE.get(), (Item)LWItems.CHEATER_CLAW.get());
        LWRecipeGen.smithing(pvd, LWToolMats.ETERNIUM.getTool(LWToolTypes.MACHETE), (Item)LCItems.VOID_EYE.get(), (Item)LWItems.CHEATER_MACHETE.get());
        currentFolder = "enchantments/";
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.HEAVY, pvd, 1)).unlockedBy(arg_0, arg_1), Items.ANVIL).pattern("AAA").pattern("CBC").pattern("LDL").define(Character.valueOf('A'), (ItemLike)Items.ANVIL).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('C'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('D'), (ItemLike)LWItems.HANDLE.get()).define(Character.valueOf('L'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.HEAVY.id()));
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.NO_AGGRO, pvd, 1)).unlockedBy(arg_0, arg_1), (Item)LCItems.CAPTURED_WIND.get()).pattern("LAL").pattern("CBC").pattern("LCL").define(Character.valueOf('A'), (ItemLike)LCItems.CAPTURED_WIND).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('C'), (ItemLike)LCItems.HARD_ICE).define(Character.valueOf('L'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.NO_AGGRO.id()));
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.ENDER_HAND, pvd, 1)).unlockedBy(arg_0, arg_1), LCMats.POSEIDITE.getIngot()).pattern("LAL").pattern("CBC").pattern("LDL").define(Character.valueOf('A'), (ItemLike)LCMats.POSEIDITE.getIngot()).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('C'), (ItemLike)Items.ENDER_EYE).define(Character.valueOf('D'), (ItemLike)LWItems.HANDLE.get()).define(Character.valueOf('L'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.ENDER_HAND.id()));
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.HEAVY_SHIELD, pvd, 1)).unlockedBy(arg_0, arg_1), Items.ANVIL).pattern("DAD").pattern("CBC").pattern("LDL").define(Character.valueOf('A'), (ItemLike)Items.ANVIL).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('D'), (ItemLike)Items.NETHERITE_INGOT).define(Character.valueOf('C'), (ItemLike)LWItems.HANDLE.get()).define(Character.valueOf('L'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.HEAVY_SHIELD.id()));
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.HARD_SHIELD, pvd, 1)).unlockedBy(arg_0, arg_1), LCMats.SHULKERATE.getIngot()).pattern("DLD").pattern("CBC").pattern("LDL").define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('D'), (ItemLike)LCMats.SHULKERATE.getIngot()).define(Character.valueOf('C'), (ItemLike)LWItems.HANDLE.get()).define(Character.valueOf('L'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.HARD_SHIELD.id()));
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.ENERGIZED_WILL, pvd, 1)).unlockedBy(arg_0, arg_1), (Item)LCItems.SOUL_FLAME.get()).pattern("CLC").pattern("DBD").pattern("CLC").define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('C'), (ItemLike)Items.REDSTONE).define(Character.valueOf('D'), (ItemLike)LCItems.SOUL_FLAME).define(Character.valueOf('L'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.ENERGIZED_WILL.id()));
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.RAISED_SPIRIT, pvd, 1)).unlockedBy(arg_0, arg_1), (Item)LCItems.SOUL_FLAME.get()).pattern("CLC").pattern("DBD").pattern("CLC").define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('C'), (ItemLike)Items.GLOWSTONE_DUST).define(Character.valueOf('D'), (ItemLike)LCItems.SOUL_FLAME).define(Character.valueOf('L'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.RAISED_SPIRIT.id()));
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.GHOST_SLASH, pvd, 1)).unlockedBy(arg_0, arg_1), (Item)LCItems.RESONANT_FEATHER.get()).pattern("CLC").pattern("DBD").pattern("CLC").define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('L'), (ItemLike)LCItems.EXPLOSION_SHARD).define(Character.valueOf('D'), (ItemLike)LCItems.RESONANT_FEATHER).define(Character.valueOf('C'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.GHOST_SLASH.id()));
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.CLAW_BLOCK, pvd, 1)).unlockedBy(arg_0, arg_1), (Item)LCItems.WARDEN_BONE_SHARD.get()).pattern("LLL").pattern("DBD").pattern("CCC").define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('L'), (ItemLike)LCItems.WARDEN_BONE_SHARD).define(Character.valueOf('D'), (ItemLike)LCItems.EXPLOSION_SHARD).define(Character.valueOf('C'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.CLAW_BLOCK.id()));
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.THIN_BLADE, pvd, 1)).unlockedBy(arg_0, arg_1), (Item)LCItems.CAPTURED_WIND.get()).pattern(" L ").pattern("CBC").pattern(" D ").define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('L'), (ItemLike)LCItems.CAPTURED_WIND).define(Character.valueOf('D'), (ItemLike)LCItems.CAPTURED_BULLET).define(Character.valueOf('C'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.THIN_BLADE.id()));
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.PROJECTION, pvd, 1)).unlockedBy(arg_0, arg_1), (Item)LCItems.VOID_EYE.get()).pattern("CBC").pattern("1E2").pattern("LDR").define(Character.valueOf('1'), EnchantmentIngredient.of((HolderLookup.Provider)pvd.getProvider(), (ResourceKey)Enchantments.INFINITY, (int)1)).define(Character.valueOf('2'), EnchantmentIngredient.of((HolderLookup.Provider)pvd.getProvider(), (ResourceKey)Enchantments.LOYALTY, (int)1)).define(Character.valueOf('L'), (ItemLike)LCItems.VOID_EYE).define(Character.valueOf('R'), (ItemLike)LCItems.GUARDIAN_EYE).define(Character.valueOf('B'), (ItemLike)Items.ZOMBIE_HEAD).define(Character.valueOf('D'), (ItemLike)Items.CONDUIT).define(Character.valueOf('E'), (ItemLike)LCMats.POSEIDITE.getIngot()).define(Character.valueOf('C'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.PROJECTION.id()));
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((EnchantmentRecipeBuilder)new EnchantmentRecipeBuilder(LWEnchantments.INSTANT_THROWING, pvd, 1)).unlockedBy(arg_0, arg_1), (Item)LCItems.STORM_CORE.get()).pattern(" B ").pattern("C1C").pattern(" E ").define(Character.valueOf('1'), EnchantmentIngredient.of((HolderLookup.Provider)pvd.getProvider(), (ResourceKey)Enchantments.QUICK_CHARGE, (int)1)).define(Character.valueOf('B'), (ItemLike)LCItems.STORM_CORE).define(Character.valueOf('E'), (ItemLike)Items.CROSSBOW).define(Character.valueOf('C'), (ItemLike)Items.LAPIS_LAZULI).save((RecipeOutput)pvd, LWRecipeGen.getID((ResourceKey<Enchantment>)LWEnchantments.INSTANT_THROWING.id()));
    }

    private static ResourceLocation getID(ResourceKey<Enchantment> item) {
        return L2Weaponry.loc(currentFolder + item.location().getPath());
    }

    public static ResourceLocation getID(Item item) {
        return L2Weaponry.loc(currentFolder + BuiltInRegistries.ITEM.getKey((Object)item).getPath());
    }

    private static ResourceLocation getID(Item item, String suffix) {
        return L2Weaponry.loc(currentFolder + BuiltInRegistries.ITEM.getKey((Object)item).getPath() + suffix);
    }

    public static <T> T unlock(RegistrateRecipeProvider pvd, BiFunction<String, Criterion<InventoryChangeTrigger.TriggerInstance>, T> func, Item item) {
        return func.apply("has_" + pvd.safeName((ItemLike)item), (Criterion<InventoryChangeTrigger.TriggerInstance>)DataIngredient.items((ItemLike)item, (ItemLike[])new Item[0]).getCriterion(pvd));
    }

    private static void buildTool(RegistrateRecipeProvider pvd, Item handle, Item ingot, ILWToolMats mat, LWToolTypes type, String ... strs) {
        if (!mat.hasTool(type)) {
            return;
        }
        Supplier<ShapedRecipeBuilder> sup = () -> {
            ShapedRecipeBuilder b = LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((ShapedRecipeBuilder)new ShapedRecipeBuilder(RecipeCategory.TOOLS, (ItemLike)mat.getTool(type), 1)).unlockedBy(arg_0, arg_1), mat.getIngot());
            boolean stick = false;
            boolean leather = false;
            boolean chain = false;
            for (String str : strs) {
                b = b.pattern(str);
                stick |= str.indexOf(72) >= 0;
                leather |= str.indexOf(76) >= 0;
                chain |= str.indexOf(67) >= 0;
            }
            b.define(Character.valueOf('I'), (ItemLike)ingot);
            if (stick) {
                b.define(Character.valueOf('H'), (ItemLike)handle);
            }
            if (leather) {
                b = b.define(Character.valueOf('L'), (ItemLike)Items.LEATHER);
            }
            if (chain) {
                b = b.define(Character.valueOf('C'), (ItemLike)Items.CHAIN);
            }
            return b;
        };
        mat.saveRecipe(sup, pvd, type, LWRecipeGen.getID(mat.getTool(type)));
    }

    public static void upgrade(RegistrateRecipeProvider pvd, ILWToolMats base, ILWToolMats mat, Item template) {
        currentFolder = "generated/upgrade/";
        for (LWToolTypes t : LWToolTypes.values()) {
            if (!mat.hasTool(t)) continue;
            LWRecipeGen.smithing(pvd, mat.getProvider(pvd, new ICondition[0]), base.getTool(t), mat.getIngot(), mat.getTool(t), template);
        }
    }

    public static void tools(RegistrateRecipeProvider pvd, Item handle, Item ingot, ILWToolMats mat) {
        Pair<ILWToolMats, Item> base = mat.getBaseUpgrade();
        if (base != null) {
            LWRecipeGen.upgrade(pvd, (ILWToolMats)base.getFirst(), mat, (Item)base.getSecond());
            return;
        }
        currentFolder = "generated/craft/";
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.CLAW, "III", "HLH", "H H");
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.DAGGER, " I", "H ");
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.HAMMER, "III", "IHI", " H ");
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.BATTLE_AXE, "III", "IH ", "H  ");
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.SCYTHE, "III", " HI", "H  ");
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.SPEAR, " II", " HI", "H  ");
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.MACHETE, "  I", " I ", " H ");
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.ROUND_SHIELD, " I ", "IHI", " I ");
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.PLATE_SHIELD, "III", "IHI", " I ");
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.THROWING_AXE, "II", "IH");
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.JAVELIN, "  I", " H ", "I  ");
        LWRecipeGen.buildTool(pvd, handle, ingot, mat, LWToolTypes.NUNCHAKU, " C ", "H H", "I I");
        currentFolder = "generated/upgrade/";
        BooleanValueCondition toggle = BooleanValueCondition.of((ConfigInit)LCConfig.RECIPE, x -> x.enableToolRecraftRecipe, (boolean)true);
        RecipeOutput cond = mat.getProvider(pvd, new ICondition[]{toggle});
        for (LWToolTypes t : LWToolTypes.values()) {
            if (!mat.hasTool(t)) continue;
            LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((SmithingTransformRecipeBuilder)SmithingTransformRecipeBuilder.smithing((Ingredient)AbstractSmithingRecipe.TEMPLATE_PLACEHOLDER, (Ingredient)Ingredient.of(t.tag), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{mat.getBlock()}), (RecipeCategory)RecipeCategory.COMBAT, (Item)mat.getTool(t))).unlocks(arg_0, arg_1), mat.getBlock()).save(cond, LWRecipeGen.getID(mat.getTool(t)));
        }
    }

    public static void smithing(RegistrateRecipeProvider pvd, TagKey<Item> in, Item mat, Item out) {
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((SmithingTransformRecipeBuilder)SmithingTransformRecipeBuilder.smithing((Ingredient)AbstractSmithingRecipe.TEMPLATE_PLACEHOLDER, (Ingredient)Ingredient.of(in), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{mat}), (RecipeCategory)RecipeCategory.COMBAT, (Item)out)).unlocks(arg_0, arg_1), mat).save((RecipeOutput)pvd, LWRecipeGen.getID(out));
    }

    public static void smithing(RegistrateRecipeProvider pvd, RecipeOutput rec, Item in, Item mat, Item out, Item template) {
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((SmithingTransformRecipeBuilder)SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{template}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{in}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{mat}), (RecipeCategory)RecipeCategory.COMBAT, (Item)out)).unlocks(arg_0, arg_1), mat).save(rec, LWRecipeGen.getID(out));
    }

    public static void smithing(RegistrateRecipeProvider pvd, Item in, Item mat, Item out) {
        Ingredient ing = mat == Items.NETHERITE_INGOT ? Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}) : AbstractSmithingRecipe.TEMPLATE_PLACEHOLDER;
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((SmithingTransformRecipeBuilder)SmithingTransformRecipeBuilder.smithing((Ingredient)ing, (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{in}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{mat}), (RecipeCategory)RecipeCategory.COMBAT, (Item)out)).unlocks(arg_0, arg_1), mat).save((RecipeOutput)pvd, LWRecipeGen.getID(out));
    }

    public static void smelting(RegistrateRecipeProvider pvd, Item source, Item result, float experience) {
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{source}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)experience, (int)200)).unlockedBy(arg_0, arg_1), source).save((RecipeOutput)pvd, LWRecipeGen.getID(source));
    }

    public static void blasting(RegistrateRecipeProvider pvd, Item source, Item result, float experience) {
        LWRecipeGen.unlock(pvd, (arg_0, arg_1) -> ((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{source}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (float)experience, (int)200)).unlockedBy(arg_0, arg_1), source).save((RecipeOutput)pvd, LWRecipeGen.getID(source));
    }
}

