/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.init;

import dev.xkmc.l2weaponry.content.client.ClawItemDecorationRenderer;
import dev.xkmc.l2weaponry.content.client.ShieldItemDecorationRenderer;
import dev.xkmc.l2weaponry.content.item.types.NunchakuItem;
import dev.xkmc.l2weaponry.init.L2Weaponry;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="l2weaponry", bus=EventBusSubscriber.Bus.MOD)
public class L2WeaponryClient {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ClampedItemPropertyFunction func = (stack, level, entity, layer) -> entity != null && entity.isBlocking() && entity.getUseItem() == stack ? 1.0f : 0.0f;
            for (Item item : LWItems.BLOCK_DECO) {
                ItemProperties.register((Item)item, (ResourceLocation)L2Weaponry.loc("blocking"), (ItemPropertyFunction)func);
            }
            func = (stack, level, entity, layer) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f;
            for (Item item : LWItems.THROW_DECO) {
                ItemProperties.register((Item)item, (ResourceLocation)L2Weaponry.loc("throwing"), (ItemPropertyFunction)func);
            }
            func = (stack, level, entity, layer) -> NunchakuItem.check(entity, stack) ? 1.0f : 0.0f;
            for (Item item : LWItems.NUNCHAKU_DECO) {
                ItemProperties.register((Item)item, (ResourceLocation)L2Weaponry.loc("spinning"), (ItemPropertyFunction)func);
            }
        });
    }

    @SubscribeEvent
    public static void registerItemDecoration(RegisterItemDecorationsEvent event) {
        ShieldItemDecorationRenderer shield = new ShieldItemDecorationRenderer();
        ClawItemDecorationRenderer claw = new ClawItemDecorationRenderer();
        for (Item i : LWItems.BLOCK_DECO) {
            event.register((ItemLike)i, (IItemDecorator)shield);
        }
        for (Item i : LWItems.CLAW_DECO) {
            event.register((ItemLike)i, (IItemDecorator)claw);
        }
    }

    @SubscribeEvent
    public static void onModelLoad(ModelEvent.RegisterAdditional event) {
        for (NunchakuItem item : LWItems.NUNCHAKU_DECO) {
            event.register(item.roll());
            event.register(item.unroll());
        }
    }
}

