/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.init;

import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.DataProviderInitializer;
import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.l2complements.events.ItemUseEventHandler;
import dev.xkmc.l2complements.init.registrate.LCEnchantments;
import dev.xkmc.l2core.init.L2TagGen;
import dev.xkmc.l2core.init.reg.registrate.L2Registrate;
import dev.xkmc.l2core.init.reg.simple.Reg;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2serial.network.PacketHandler;
import dev.xkmc.l2weaponry.compat.GolemCompat;
import dev.xkmc.l2weaponry.events.LWAttackEventListener;
import dev.xkmc.l2weaponry.events.LWClickListener;
import dev.xkmc.l2weaponry.init.data.LWAttributeConfigGen;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import dev.xkmc.l2weaponry.init.data.LWDamageTypeGen;
import dev.xkmc.l2weaponry.init.data.LWRecipeGen;
import dev.xkmc.l2weaponry.init.data.LWTagGen;
import dev.xkmc.l2weaponry.init.data.LangData;
import dev.xkmc.l2weaponry.init.data.ModFilePackResources;
import dev.xkmc.l2weaponry.init.materials.LWGenItem;
import dev.xkmc.l2weaponry.init.materials.LWItemModelProvider;
import dev.xkmc.l2weaponry.init.registrate.LWEnchantments;
import dev.xkmc.l2weaponry.init.registrate.LWEntities;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.entity.EntityType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="l2weaponry")
@EventBusSubscriber(modid="l2weaponry", bus=EventBusSubscriber.Bus.MOD)
public class L2Weaponry {
    public static final String MODID = "l2weaponry";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Reg REG = new Reg("l2weaponry");
    public static final L2Registrate REGISTRATE = new L2Registrate("l2weaponry");
    public static final PacketHandler HANDLER = new PacketHandler("l2weaponry", 1, new Function[0]);

    public L2Weaponry(IEventBus bus) {
        LWItems.register();
        LWEntities.register();
        LWDamageTypeGen.register();
        LWConfig.init();
        LWEnchantments.register();
        ItemUseEventHandler.LIST.add(new LWClickListener());
        if (ModList.get().isLoaded("modulargolems")) {
            GolemCompat.register(bus);
        }
    }

    public static ResourceLocation loc(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> AttackEventHandler.register((int)4000, (AttackListener)new LWAttackEventListener()));
    }

    @SubscribeEvent
    public static void modifyAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, LWItems.SHIELD_DEFENSE.holder());
        event.add(EntityType.PLAYER, LWItems.REFLECT_TIME.holder());
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void gatherData(GatherDataEvent event) {
        REGISTRATE.addDataGenerator(ProviderType.LANG, LangData::addTranslations);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, LWRecipeGen::genRecipe);
        REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, LWTagGen::onBlockTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, LWTagGen::onItemTagGen);
        REGISTRATE.addDataGenerator(ProviderType.ENTITY_TAGS, LWTagGen::onEntityTagGen);
        REGISTRATE.addDataGenerator(ProviderType.DATA_MAP, LWAttributeConfigGen::onDataMapGen);
        new LWDamageTypeGen(REGISTRATE).generate();
        DataProviderInitializer init = REGISTRATE.getDataGenInitializer();
        LWEnchantments.REG.addParent(LCEnchantments.REG);
        init.addDependency(ProviderType.RECIPE, L2TagGen.ENCH_TAGS);
        LWGenItem.ALT = new LWItemModelProvider((AbstractRegistrate<?>)REGISTRATE, event.getGenerator().getPackOutput(), event.getExistingFileHelper());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void gatherDataLate(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeClient(), (DataProvider)LWGenItem.ALT);
    }

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            IModFileInfo modFileInfo = ModList.get().getModFileById(MODID);
            if (modFileInfo == null) {
                return;
            }
            String builtin = "old_weapon_model";
            IModFile modFile = modFileInfo.getFile();
            event.addRepositorySource(consumer -> {
                Pack pack = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo("l2weaponry:" + builtin, (Component)Component.literal((String)"Old L2Weaponry Model"), PackSource.FEATURE, Optional.empty()), (Pack.ResourcesSupplier)new ModFilePackResources(modFile, "resourcepacks/" + builtin), (PackType)PackType.CLIENT_RESOURCES, (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.TOP, false));
                if (pack != null) {
                    consumer.accept(pack);
                }
            });
        }
    }
}

