/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.events;

import dev.xkmc.l2complements.events.ItemUseEventHandler;
import dev.xkmc.l2weaponry.content.item.base.IStackableWeapon;
import dev.xkmc.l2weaponry.content.item.base.WeaponItem;
import dev.xkmc.l2weaponry.init.registrate.LWEnchantments;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class LWClickListener
implements ItemUseEventHandler.ItemClickHandler {
    public boolean predicate(ItemStack itemStack, Class<? extends PlayerEvent> aClass, PlayerEvent playerEvent) {
        return itemStack.getItem() instanceof WeaponItem;
    }

    public void onPlayerLeftClickEmpty(ItemStack stack, PlayerInteractEvent.LeftClickEmpty event) {
        Item item;
        if (!event.getLevel().isClientSide() && (item = stack.getItem()) instanceof IStackableWeapon) {
            IStackableWeapon item2 = (IStackableWeapon)item;
            LWClickListener.doubleWeldSwing(event.getEntity(), item2, stack);
        }
    }

    public void onPlayerLeftClickBlock(ItemStack stack, PlayerInteractEvent.LeftClickBlock event) {
        Item item;
        if (!event.getLevel().isClientSide() && (item = stack.getItem()) instanceof IStackableWeapon) {
            IStackableWeapon item2 = (IStackableWeapon)item;
            LWClickListener.doubleWeldSwing(event.getEntity(), item2, stack);
        }
    }

    private static void doubleWeldSwing(Player player, IStackableWeapon item, ItemStack stack) {
        if (LWEnchantments.GHOST_SLASH.getLv(stack) > 0 && (double)player.getAttackStrengthScale(0.0f) >= 0.9) {
            item.accumulateDamage(stack, (LivingEntity)player);
            if (!player.getAbilities().instabuild) {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
    }
}

