/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.events;

import dev.xkmc.l2complements.content.enchantment.core.SourceModifierEnchantment;
import dev.xkmc.l2core.init.reg.ench.EnchHolder;
import dev.xkmc.l2core.init.reg.ench.LegacyEnchantment;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.attack.PlayerAttackCache;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2damagetracker.contents.materials.generic.GenericTieredItem;
import dev.xkmc.l2weaponry.content.entity.BaseThrownWeaponEntity;
import dev.xkmc.l2weaponry.content.item.base.IStackableWeapon;
import dev.xkmc.l2weaponry.content.item.base.LWTieredItem;
import dev.xkmc.l2weaponry.content.item.legendary.LegendaryWeapon;
import dev.xkmc.l2weaponry.init.L2Weaponry;
import dev.xkmc.l2weaponry.init.materials.LWExtraConfig;
import dev.xkmc.l2weaponry.init.registrate.LWEnchantments;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;

public class LWAttackEventListener
implements AttackListener {
    public static final ResourceLocation STRENGTH_CHECK = L2Weaponry.loc("attack_strength_check");
    public static final ResourceLocation WEAPON_BONUS = L2Weaponry.loc("weapon_type_bonus");

    public void onCreateSource(CreateSourceEvent event) {
        if (event.getOriginal().equals(DamageTypes.MOB_ATTACK) || event.getOriginal().equals(DamageTypes.PLAYER_ATTACK)) {
            ItemStack stack = event.getAttacker().getMainHandItem();
            Item item = stack.getItem();
            if (item instanceof LWTieredItem) {
                LWTieredItem item2 = (LWTieredItem)item;
                Entity target = Optional.of(event).map(CreateSourceEvent::getPlayerAttackCache).map(PlayerAttackCache::getPlayerAttackEntityEvent).map(AttackEntityEvent::getTarget).orElse(null);
                item2.modifySource(event.getAttacker(), event, event.getAttacker().getMainHandItem(), target);
            }
        } else {
            BaseThrownWeaponEntity thrown;
            Item target;
            Entity stack = event.getDirect();
            if (stack instanceof BaseThrownWeaponEntity && (target = (stack = (thrown = (BaseThrownWeaponEntity)stack).getItem()).getItem()) instanceof LWTieredItem) {
                LWTieredItem weapon = (LWTieredItem)target;
                Entity entity = thrown.getOwner();
                if (entity instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)entity;
                    weapon.modifySource(le, event, (ItemStack)stack, thrown.targetCache);
                    LegacyEnchantment.findAll((ItemStack)stack, SourceModifierEnchantment.class, (boolean)true).forEach(arg_0 -> LWAttackEventListener.lambda$onCreateSource$0(event, (ItemStack)stack, arg_0));
                }
            }
        }
    }

    public void setupProfile(DamageData data, BiConsumer<LivingEntity, ItemStack> setup) {
        BaseThrownWeaponEntity thrown;
        Entity entity;
        Entity entity2 = data.getSource().getDirectEntity();
        if (entity2 instanceof BaseThrownWeaponEntity && (entity = (thrown = (BaseThrownWeaponEntity)entity2).getOwner()) instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            setup.accept(le, thrown.getItem());
        }
    }

    public boolean onAttack(DamageData.Attack data) {
        Item item = data.getTarget().getMainHandItem().getItem();
        if (item instanceof LegendaryWeapon) {
            LegendaryWeapon weapon = (LegendaryWeapon)item;
            return weapon.isImmuneTo(data.getSource());
        }
        return false;
    }

    public void onHurt(DamageData.Offence data) {
        LivingEntity le = data.getAttacker();
        if (le == null) {
            return;
        }
        ItemStack stack = data.getWeapon();
        if (stack.isEmpty()) {
            return;
        }
        if (stack.getItem() instanceof GenericTieredItem && data.getStrength() < 0.7f) {
            data.addHurtModifier(DamageModifier.nonlinearFinal((int)10000, f -> 0.1f, (ResourceLocation)STRENGTH_CHECK));
            return;
        }
        Item item = stack.getItem();
        if (item instanceof LWTieredItem) {
            LWTieredItem w = (LWTieredItem)item;
            data.addHurtModifier(DamageModifier.multAttr((float)w.getMultiplier(data), (ResourceLocation)WEAPON_BONUS));
        }
        if ((item = stack.getItem()) instanceof LegendaryWeapon) {
            LegendaryWeapon weapon = (LegendaryWeapon)item;
            weapon.onHurt(data, le, stack);
        }
    }

    public void onHurtMaximized(DamageData.OffenceMax data) {
        LivingEntity le = data.getAttacker();
        if (le == null) {
            return;
        }
        ItemStack stack = data.getWeapon();
        if (stack.isEmpty()) {
            return;
        }
        Item item = stack.getItem();
        if (item instanceof LegendaryWeapon) {
            LegendaryWeapon weapon = (LegendaryWeapon)item;
            weapon.onHurtMaximized(data, le);
        }
        if ((item = stack.getItem()) instanceof IStackableWeapon) {
            IStackableWeapon claw = (IStackableWeapon)item;
            claw.accumulateDamage(stack, le);
        }
    }

    public void onDamageFinalized(DamageData.DefenceMax data) {
        block6: {
            ItemStack stack;
            LivingEntity le;
            block7: {
                Object c;
                LWTieredItem w;
                ExtraToolConfig extraToolConfig;
                le = data.getAttacker();
                stack = data.getWeapon();
                if (le == null || stack.isEmpty()) {
                    return;
                }
                Item item = stack.getItem();
                if (item instanceof LWTieredItem && (extraToolConfig = (w = (LWTieredItem)item).getExtraConfig()) instanceof LWExtraConfig) {
                    c = (LWExtraConfig)extraToolConfig;
                    c.onDamageFinal(data, le, stack);
                }
                if ((c = stack.getItem()) instanceof LegendaryWeapon) {
                    LegendaryWeapon weapon = (LegendaryWeapon)c;
                    weapon.onDamageFinal(data, le);
                }
                if (!((c = stack.getItem()) instanceof IStackableWeapon)) break block6;
                IStackableWeapon item2 = (IStackableWeapon)c;
                if (LWEnchantments.GHOST_SLASH.getLv(stack) <= 0 || !((double)data.getStrength() >= 0.9)) break block6;
                item2.accumulateDamage(stack, le);
                if (!(le instanceof Player)) break block7;
                Player player = (Player)le;
                if (player.getAbilities().instabuild) break block6;
            }
            stack.hurtAndBreak(1, le, EquipmentSlot.MAINHAND);
        }
    }

    public boolean onCriticalHit(PlayerAttackCache cache, CriticalHitEvent event) {
        if (!event.isVanillaCritical() && !event.isCriticalHit()) {
            return false;
        }
        if (event.getEntity().level().isClientSide()) {
            return false;
        }
        Item item = cache.getWeapon().getItem();
        if (item instanceof LegendaryWeapon) {
            LegendaryWeapon weapon = (LegendaryWeapon)item;
            weapon.onCrit(event.getEntity(), event.getTarget());
        }
        return false;
    }

    private static /* synthetic */ void lambda$onCreateSource$0(CreateSourceEvent event, ItemStack stack, EnchHolder x) {
        ((SourceModifierEnchantment)x.val()).modify(event, stack, x.lv());
    }
}

