/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.events;

import dev.xkmc.l2core.util.Proxy;
import dev.xkmc.l2weaponry.content.item.base.DoubleWieldItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHandEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="l2weaponry", bus=EventBusSubscriber.Bus.GAME)
public class ClientRenderEvents {
    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        LocalPlayer player = Proxy.getClientPlayer();
        Item main = player.getMainHandItem().getItem();
        Item off = player.getOffhandItem().getItem();
        if (main instanceof DoubleWieldItem && main == off) {
            if (event.getHand() == InteractionHand.MAIN_HAND) {
                Minecraft.getInstance().getEntityRenderDispatcher().getItemInHandRenderer().renderArmWithItem((AbstractClientPlayer)player, event.getPartialTick(), event.getInterpolatedPitch(), InteractionHand.OFF_HAND, event.getSwingProgress(), player.getOffhandItem(), event.getEquipProgress(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
            } else {
                event.setCanceled(true);
            }
        }
    }

    public static void onNunchakuUse(Player player, ItemStack stack) {
        if (player != Proxy.getClientPlayer()) {
            return;
        }
        MultiPlayerGameMode mode = Minecraft.getInstance().gameMode;
        if (mode == null) {
            return;
        }
        float cd = player.getAttackStrengthScale(1.0f);
        if (cd < 1.0f) {
            return;
        }
        HitResult hit = Minecraft.getInstance().hitResult;
        if (hit instanceof EntityHitResult) {
            EntityHitResult entityResult = (EntityHitResult)hit;
            Entity entity = entityResult.getEntity();
            if (!entity.isAlive()) {
                return;
            }
            if (!(entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity instanceof AbstractArrow)) {
                mode.attack(player, entity);
            }
        }
    }
}

