/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.types;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.content.entity.BaseThrownWeaponEntity;
import dev.xkmc.l2weaponry.content.entity.DaggerEntity;
import dev.xkmc.l2weaponry.content.item.base.BaseThrowableWeaponItem;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import dev.xkmc.l2weaponry.init.data.LangData;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DaggerItem
extends BaseThrowableWeaponItem {
    public DaggerItem(Tier tier, Item.Properties prop, ExtraToolConfig config) {
        super(tier, prop, config, (TagKey<Block>)BlockTags.MINEABLE_WITH_HOE);
    }

    @Override
    public BaseThrownWeaponEntity<?> getProjectile(Level level, LivingEntity player, ItemStack stack, int slot) {
        return new DaggerEntity(level, player, stack, slot);
    }

    @Override
    protected void shoot(AbstractArrow proj, ItemStack stack, Level level, Player player) {
        proj.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 3.0f, 0.0f);
    }

    @Override
    public float getMultiplier(DamageData.Offence event) {
        Mob le;
        LivingEntity livingEntity = event.getTarget();
        return livingEntity instanceof Mob && (le = (Mob)livingEntity).getTarget() != event.getAttacker() ? (float)((Double)LWConfig.SERVER.dagger_bonus.get()).doubleValue() : 1.0f;
    }

    @Override
    protected int getInstantThrowCoolDown() {
        return (Integer)LWConfig.SERVER.daggerInstantThrowCooldown.get();
    }

    @Override
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        list.add((Component)LangData.TOOL_DAGGER.get(new Object[0]));
        list.add((Component)LangData.TOOL_THROW_DAGGER.get(new Object[0]));
        super.appendHoverText(pStack, pLevel, list, pIsAdvanced);
    }
}

