/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.legendary;

import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TeleportUtil {
    public static boolean teleport(Player player, LivingEntity target, boolean back) {
        if (player.level().isClientSide) {
            return true;
        }
        Vec3 tPos = target.position();
        double reach = player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE) - 0.5;
        Vec3 end = back ? RayTraceUtil.getRayTerm((Vec3)tPos, (float)target.getXRot(), (float)target.getYRot(), (double)(-reach)) : RayTraceUtil.getRayTerm((Vec3)tPos, (float)player.getXRot(), (float)player.getYRot(), (double)(-reach));
        BlockPos pos = BlockPos.containing((Position)end);
        AABB aabb = player.getBoundingBox();
        for (int i = 0; i < 5; ++i) {
            BlockPos iPos = pos.above(i);
            Vec3 cen = new Vec3((double)iPos.getX() + 0.5, (double)(iPos.getY() + 1), (double)iPos.getZ() + 0.5);
            AABB iab = aabb.move(cen.subtract(aabb.getCenter()));
            if (!player.level().noCollision((Entity)player, iab)) continue;
            player.teleportTo((double)iPos.getX() + 0.5, (double)iPos.getY(), (double)iPos.getZ() + 0.5);
            player.lookAt(EntityAnchorArgument.Anchor.EYES, target.getEyePosition());
            player.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            player.level().gameEvent((Holder)GameEvent.TELEPORT, iPos, GameEvent.Context.of((Entity)player));
            return true;
        }
        return false;
    }
}

