/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.legendary;

import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.content.entity.BaseThrownWeaponEntity;
import dev.xkmc.l2weaponry.content.item.legendary.LegendaryWeapon;
import dev.xkmc.l2weaponry.content.item.types.JavelinItem;
import dev.xkmc.l2weaponry.init.data.LangData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.Vec3;

public class StormJavelin
extends JavelinItem
implements LegendaryWeapon {
    public StormJavelin(Tier tier, Item.Properties prop, ExtraToolConfig config) {
        super(tier, prop, config);
    }

    @Override
    public boolean causeThunder(BaseThrownWeaponEntity<?> entity) {
        return true;
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity user) {
        ServerPlayer serverPlayer;
        super.hurtEnemy(stack, target, user);
        if (user.level().isClientSide) {
            return true;
        }
        BlockPos blockpos = target.blockPosition();
        LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(user.level());
        assert (bolt != null);
        bolt.addTag("l2library:safe_lightning");
        bolt.moveTo(Vec3.atBottomCenterOf((Vec3i)blockpos));
        bolt.setCause(user instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)user) : null);
        user.level().addFreshEntity((Entity)bolt);
        user.playSound((SoundEvent)SoundEvents.TRIDENT_THUNDER.value(), 5.0f, 1.0f);
        return true;
    }

    @Override
    public boolean isImmuneTo(DamageSource source) {
        return source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypeTags.IS_LIGHTNING);
    }

    @Override
    public boolean canSweep() {
        return true;
    }

    @Override
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        list.add((Component)LangData.STORM_JAVELIN.get(new Object[0]));
    }
}

