/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.legendary;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.content.item.legendary.LegendaryWeapon;
import dev.xkmc.l2weaponry.content.item.types.BattleAxeItem;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import dev.xkmc.l2weaponry.init.data.LangData;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class HolyAxe
extends BattleAxeItem
implements LegendaryWeapon {
    public HolyAxe(Tier tier, Item.Properties prop, ExtraToolConfig config) {
        super(tier, prop, config);
    }

    @Override
    public void onHurt(DamageData.Offence event, LivingEntity le, ItemStack stack) {
        if ((double)event.getStrength() < 0.9) {
            return;
        }
        float ans = le.getAbsorptionAmount();
        float health = event.getTarget().getHealth();
        if (health > 0.0f) {
            AttributeInstance ins = le.getAttribute(Attributes.MAX_ABSORPTION);
            if (ins == null) {
                return;
            }
            double max = (Double)LWConfig.SERVER.dogmaticStandoffMax.get();
            double inc = (Double)LWConfig.SERVER.dogmaticStandoffGain.get();
            ins.addOrReplacePermanentModifier(new AttributeModifier(this.id(), (double)health * max, AttributeModifier.Operation.ADD_VALUE));
            le.setAbsorptionAmount((float)((double)ans + (double)health * inc));
        }
    }

    @Override
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        int max = (int)Math.round((Double)LWConfig.SERVER.dogmaticStandoffMax.get() * 100.0);
        int inc = (int)Math.round((Double)LWConfig.SERVER.dogmaticStandoffGain.get() * 100.0);
        list.add((Component)LangData.HOLY_AXE.get(inc, max));
    }
}

