/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.legendary;

import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2library.content.raytrace.IGlowingTarget;
import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import dev.xkmc.l2weaponry.content.item.legendary.LegendaryWeapon;
import dev.xkmc.l2weaponry.content.item.legendary.TeleportUtil;
import dev.xkmc.l2weaponry.content.item.types.SpearItem;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import dev.xkmc.l2weaponry.init.data.LangData;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EnderSpear
extends SpearItem
implements LegendaryWeapon,
IGlowingTarget {
    public EnderSpear(Tier tier, Item.Properties prop, ExtraToolConfig config) {
        super(tier, prop, config);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        LivingEntity target = RayTraceUtil.serverGetTarget((Player)player);
        if (target != null && (level.isClientSide() || TeleportUtil.teleport(player, target, false))) {
            if (!level.isClientSide()) {
                player.getCooldowns().addCooldown((Item)this, 60);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (player.getCooldowns().getCooldownPercent((Item)this, 0.0f) > 0.0f) {
            return InteractionResult.PASS;
        }
        if (player.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (TeleportUtil.teleport(player, target, false)) {
            player.getCooldowns().addCooldown((Item)this, 60);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        list.add((Component)LangData.ENDER_SPEAR.get(this.getDistance(pStack)));
    }

    public int getDistance(ItemStack itemStack) {
        return (Integer)LWConfig.SERVER.hauntingDemonDistance.get();
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, level, entity, slot, selected);
        if (selected && level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            RayTraceUtil.clientUpdateTarget((Player)player, (double)this.getDistance(stack));
        }
    }
}

