/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.legendary;

import dev.xkmc.l2damagetracker.contents.attack.CreateSourceEvent;
import dev.xkmc.l2damagetracker.contents.damage.DamageState;
import dev.xkmc.l2damagetracker.contents.damage.DefaultDamageState;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2library.content.raytrace.IGlowingTarget;
import dev.xkmc.l2library.content.raytrace.RayTraceUtil;
import dev.xkmc.l2weaponry.content.item.legendary.LegendaryWeapon;
import dev.xkmc.l2weaponry.content.item.legendary.TeleportUtil;
import dev.xkmc.l2weaponry.content.item.types.DaggerItem;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import dev.xkmc.l2weaponry.init.data.LangData;
import dev.xkmc.l2weaponry.mixin.TargetGoalAccessor;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EnderDagger
extends DaggerItem
implements LegendaryWeapon,
IGlowingTarget {
    public EnderDagger(Tier tier, Item.Properties prop, ExtraToolConfig config) {
        super(tier, prop, config);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        LivingEntity target = RayTraceUtil.serverGetTarget((Player)player);
        if (target != null && (level.isClientSide() || TeleportUtil.teleport(player, target, true))) {
            this.clearTarget(target, player);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (player.getCooldowns().getCooldownPercent((Item)this, 0.0f) > 0.0f) {
            return InteractionResult.PASS;
        }
        if (player.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (TeleportUtil.teleport(player, target, true)) {
            this.clearTarget(target, player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void modifySource(LivingEntity attacker, CreateSourceEvent event, ItemStack item, @Nullable Entity target) {
        Mob mob;
        if (target instanceof Mob && (mob = (Mob)target).getTarget() != attacker) {
            event.enable((DamageState)DefaultDamageState.BYPASS_ARMOR);
        }
    }

    @Override
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        list.add((Component)LangData.ENDER_DAGGER.get(this.getDistance(pStack)));
    }

    public int getDistance(ItemStack itemStack) {
        return (Integer)LWConfig.SERVER.shadowHunterDistance.get();
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, level, entity, slot, selected);
        if (selected && level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            RayTraceUtil.clientUpdateTarget((Player)player, (double)this.getDistance(stack));
        }
    }

    private void clearTarget(LivingEntity target, Player player) {
        Mob mob;
        if (target instanceof Mob && (mob = (Mob)target).getTarget() == player) {
            mob.setTarget(null);
            mob.setLastHurtByMob(null);
            mob.setLastHurtByPlayer(null);
            if (mob instanceof NeutralMob) {
                NeutralMob neutral = (NeutralMob)mob;
                neutral.setPersistentAngerTarget(null);
            }
            for (WrappedGoal e : mob.targetSelector.getAvailableGoals()) {
                Goal g = e.getGoal();
                if (g instanceof WrappedGoal) {
                    WrappedGoal w = (WrappedGoal)g;
                    g = w.getGoal();
                }
                if (!(g instanceof TargetGoal)) continue;
                TargetGoal t = (TargetGoal)g;
                ((TargetGoalAccessor)t).setTargetMob(null);
            }
        }
        player.getCooldowns().addCooldown((Item)this, 60);
    }
}

