/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.legendary;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.content.item.legendary.LegendaryWeapon;
import dev.xkmc.l2weaponry.content.item.types.ScytheItem;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import dev.xkmc.l2weaponry.init.data.LangData;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class DeathScythe
extends ScytheItem
implements LegendaryWeapon {
    public DeathScythe(Tier tier, Item.Properties prop, ExtraToolConfig config) {
        super(tier, prop, config);
    }

    @Override
    public void onHurt(DamageData.Offence event, LivingEntity le, ItemStack stack) {
        if ((double)event.getStrength() < 0.9) {
            return;
        }
        float health = event.getTarget().getHealth();
        float max = event.getTarget().getMaxHealth();
        float factor = (float)((Double)LWConfig.SERVER.deathScytheMax.get()).doubleValue();
        event.addHurtModifier(DamageModifier.multTotal((float)(1.0f + factor * (1.0f - health / max)), (ResourceLocation)this.id()));
    }

    @Override
    public void appendHoverText(ItemStack pStack, Item.TooltipContext pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        int max = (int)Math.round((Double)LWConfig.SERVER.deathScytheMax.get() * 100.0);
        list.add((Component)LangData.DEATH_SCYTHE.get(max));
    }
}

