/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.legendary;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.content.item.legendary.LegendaryWeapon;
import dev.xkmc.l2weaponry.content.item.types.ClawItem;
import dev.xkmc.l2weaponry.init.data.LangData;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;

public class BloodClaw
extends ClawItem
implements LegendaryWeapon {
    private static final String KEY_KILL = "killCount";

    private static int getBonus(int kill) {
        if (kill <= 0) {
            return 0;
        }
        return (int)Math.round(Math.log(kill) / Math.log(2.0));
    }

    public BloodClaw(Tier tier, Item.Properties prop, ExtraToolConfig config) {
        super(tier, prop, config);
    }

    @Override
    public void onDamageFinal(DamageData.DefenceMax cache, LivingEntity le) {
        le.heal(cache.getDamageFinal());
    }

    @Override
    protected int getMaxStackIntrinsic(ItemStack stack) {
        return super.getMaxStackIntrinsic(stack) + BloodClaw.getBonus((Integer)LWItems.KILL_COUNT.getOrDefault(stack, (Object)0));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        int kill = (Integer)LWItems.KILL_COUNT.getOrDefault(stack, (Object)0);
        list.add((Component)LangData.BLOOD_CLAW.get(new Object[0]));
        list.add((Component)LangData.STAT_KILL.get(Component.literal((String)("" + kill))));
        list.add((Component)LangData.STAT_BONUS_CLAW.get(Component.literal((String)("+" + BloodClaw.getBonus(kill)))));
    }

    @Override
    public void onKill(ItemStack stack, LivingEntity target, LivingEntity user) {
        if (target instanceof Enemy) {
            int kill = (Integer)LWItems.KILL_COUNT.getOrDefault(stack, (Object)0);
            LWItems.KILL_COUNT.set(stack, (Object)(kill + 1));
        }
    }
}

