/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.base;

import dev.xkmc.l2core.init.reg.ench.EnchHelper;
import dev.xkmc.l2weaponry.content.entity.BaseThrownWeaponEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;

public interface IThrowableCallback {
    default public void onHitBlock(BaseThrownWeaponEntity<?> entity, ItemStack item) {
        if (this.causeThunder(entity)) {
            IThrowableCallback.thunderHit(entity);
        }
    }

    default public void onHitEntity(BaseThrownWeaponEntity<?> entity, ItemStack item, LivingEntity le) {
        if (this.causeThunder(entity)) {
            IThrowableCallback.thunderHit(entity);
        }
    }

    default public boolean causeThunder(BaseThrownWeaponEntity<?> entity) {
        return entity.level().isThundering() && entity.level().canSeeSky(entity.blockPosition()) && EnchHelper.getLv((ItemStack)entity.getItem(), (ResourceKey)Enchantments.CHANNELING) > 0;
    }

    public static void thunderHit(BaseThrownWeaponEntity<?> entity) {
        if (entity.level().isClientSide) {
            return;
        }
        BlockPos blockpos = entity.blockPosition();
        LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(entity.level());
        if (!1.$assertionsDisabled && bolt == null) {
            throw new AssertionError();
        }
        bolt.addTag("l2library:safe_lightning");
        bolt.moveTo(Vec3.atBottomCenterOf((Vec3i)blockpos));
        bolt.setCause(entity.getOwner() instanceof ServerPlayer ? (ServerPlayer)entity.getOwner() : null);
        entity.level().addFreshEntity((Entity)bolt);
        entity.playSound((SoundEvent)SoundEvents.TRIDENT_THUNDER.value(), 5.0f, 1.0f);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

