/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.base;

import dev.xkmc.l2weaponry.init.data.LWConfig;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface IStackableWeapon {
    public static int getHitCount(ItemStack stack) {
        return (Integer)LWItems.HIT_COUNT.getOrDefault(stack, (Object)0);
    }

    public static long getLastTime(ItemStack stack) {
        return (Long)LWItems.HIT_TIME.getOrDefault(stack, (Object)0L);
    }

    default public void register(Item item) {
        LWItems.CLAW_DECO.add(item);
    }

    default public int getMaxStack(ItemStack stack, @Nullable LivingEntity user) {
        return 0;
    }

    default public void accumulateDamage(ItemStack stack, LivingEntity entity) {
        long last;
        int max = this.getMaxStack(stack, entity);
        if (max <= 0) {
            return;
        }
        long gameTime = entity.level().getGameTime();
        if (gameTime > (last = IStackableWeapon.getLastTime(stack)) + (long)((Integer)LWConfig.SERVER.claw_timeout.get()).intValue()) {
            LWItems.HIT_COUNT.set(stack, (Object)1);
        } else {
            int count = IStackableWeapon.getHitCount(stack);
            count = Math.min(count + 1, max);
            LWItems.HIT_COUNT.set(stack, (Object)count);
        }
        LWItems.HIT_TIME.set(stack, (Object)gameTime);
    }

    default public void tick(ItemStack stack, Entity entity) {
        long last;
        if (this.getMaxStack(stack, null) <= 0) {
            return;
        }
        long gameTime = entity.level().getGameTime();
        if (gameTime > (last = IStackableWeapon.getLastTime(stack)) + (long)((Integer)LWConfig.SERVER.claw_timeout.get()).intValue()) {
            stack.remove(LWItems.HIT_COUNT);
            stack.remove(LWItems.HIT_TIME);
        }
    }
}

