/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.base;

import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.content.item.base.IStackableWeapon;
import dev.xkmc.l2weaponry.content.item.base.LWTieredItem;
import dev.xkmc.l2weaponry.content.item.base.WeaponItem;
import dev.xkmc.l2weaponry.init.materials.LWExtraConfig;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;

public class GenericWeaponItem
extends WeaponItem
implements LWTieredItem,
IStackableWeapon {
    private final ExtraToolConfig config;

    public GenericWeaponItem(Tier tier, Item.Properties prop, ExtraToolConfig config, TagKey<Block> tags) {
        super(tier, tier.createToolProperties(tags), prop);
        this.config = config;
        this.register((Item)this);
    }

    @MustBeInvokedByOverriders
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        this.config.inventoryTick(stack, level, entity, slot, selected);
        this.tick(stack, entity);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return this.config.damageItem(stack, amount, entity);
    }

    public ExtraToolConfig getExtraConfig() {
        return this.config;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers parent = super.getDefaultAttributeModifiers(stack);
        ItemAttributeModifiers.Builder b = ItemAttributeModifiers.builder();
        for (ItemAttributeModifiers.Entry e : parent.modifiers()) {
            b.add(e.attribute(), e.modifier(), e.slot());
        }
        this.config.modifyDynamicAttributes(b, stack);
        return b.build();
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        float old = super.getDestroySpeed(stack, state);
        return this.config.getDestroySpeed(stack, state, old);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        this.config.addTooltip(stack, list);
    }

    @Override
    public boolean isSharp() {
        return true;
    }

    public boolean canSweep() {
        return false;
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        if (toolAction == ItemAbilities.SWORD_DIG) {
            return true;
        }
        if (toolAction == ItemAbilities.SWORD_SWEEP) {
            return this.canSweep();
        }
        return false;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(Enchantments.SWEEPING_EDGE)) {
            return this.canSweep();
        }
        if (enchantment.is(Enchantments.SHARPNESS)) {
            return this.isSharp();
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    @Override
    public final int getMaxStack(ItemStack stack, @Nullable LivingEntity user) {
        int ans = this.getMaxStackIntrinsic(stack);
        ExtraToolConfig extraToolConfig = this.config;
        if (extraToolConfig instanceof LWExtraConfig) {
            LWExtraConfig c = (LWExtraConfig)extraToolConfig;
            ans += c.getExtraStacking(stack, user);
        }
        if (user != null) {
            ans = this.getMaxStackUserBonus(ans, stack, user);
        }
        return ans;
    }

    protected int getMaxStackIntrinsic(ItemStack stack) {
        return 0;
    }

    protected int getMaxStackUserBonus(int count, ItemStack stack, LivingEntity user) {
        return count;
    }
}

