/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.base;

import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.content.item.base.BaseShieldItem;
import dev.xkmc.l2weaponry.content.item.base.LWTieredItem;
import dev.xkmc.l2weaponry.init.materials.LWExtraConfig;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class GenericShieldItem
extends BaseShieldItem
implements LWTieredItem {
    private final Tier tier;
    private final ExtraToolConfig config;

    public GenericShieldItem(Tier tier, Item.Properties prop, ExtraToolConfig config, boolean lightWeight) {
        super(prop.durability(tier.getUses()), lightWeight);
        this.tier = tier;
        this.config = config;
    }

    @Override
    public boolean isHeavy() {
        return !this.lightWeight;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.tier.getEnchantmentValue();
    }

    public boolean isValidRepairItem(ItemStack pToRepair, ItemStack pRepair) {
        return this.tier.getRepairIngredient().test(pRepair) || super.isValidRepairItem(pToRepair, pRepair);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, level, entity, slot, selected);
        this.config.inventoryTick(stack, level, entity, slot, selected);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        return this.config.damageItem(stack, super.damageItem(stack, amount, entity, onBroken), entity);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers parent = super.getDefaultAttributeModifiers(stack);
        ItemAttributeModifiers.Builder b = ItemAttributeModifiers.builder();
        for (ItemAttributeModifiers.Entry e : parent.modifiers()) {
            b.add(e.attribute(), e.modifier(), e.slot());
        }
        this.config.modifyDynamicAttributes(b, stack);
        return b.build();
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        float old = super.getDestroySpeed(stack, state);
        return this.config.getDestroySpeed(stack, state, old);
    }

    public ExtraToolConfig getExtraConfig() {
        return this.config;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(stack, level, list, flag);
        this.config.addTooltip(stack, list);
    }

    @Override
    public void onBlock(ItemStack stack, LivingEntity user, LivingEntity target) {
        ExtraToolConfig extraToolConfig = this.getExtraConfig();
        if (extraToolConfig instanceof LWExtraConfig) {
            LWExtraConfig extra = (LWExtraConfig)extraToolConfig;
            extra.onShieldBlock(stack, user, target);
        }
    }

    @Override
    public double onReflect(ItemStack stack, LivingEntity user, LivingEntity target, double original, double reflect) {
        ExtraToolConfig extraToolConfig = this.getExtraConfig();
        if (extraToolConfig instanceof LWExtraConfig) {
            LWExtraConfig extra = (LWExtraConfig)extraToolConfig;
            return extra.onShieldReflect(stack, user, target, original, reflect);
        }
        return reflect;
    }

    @Override
    protected DamageSource getReflectSource(Player player) {
        LWExtraConfig extra;
        DamageSource ans;
        ExtraToolConfig extraToolConfig = this.getExtraConfig();
        if (extraToolConfig instanceof LWExtraConfig && (ans = (extra = (LWExtraConfig)extraToolConfig).getReflectSource(player)) != null) {
            return ans;
        }
        return super.getReflectSource(player);
    }
}

