/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.base;

import dev.xkmc.l2core.events.SchedulerHandler;
import dev.xkmc.l2weaponry.content.capability.IShieldData;
import dev.xkmc.l2weaponry.content.capability.LWPlayerData;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public abstract class BaseShieldItem
extends ShieldItem {
    public static final String KEY_LAST_DAMAGE = "last_damage";
    protected final boolean lightWeight;

    public BaseShieldItem(Item.Properties pProperties, boolean lightWeight) {
        super(pProperties);
        this.lightWeight = lightWeight;
        LWItems.BLOCK_DECO.add((Item)this);
    }

    public void takeDamage(ItemStack stack, Player player, int amount) {
        int cd;
        LWItems.BLOCKED_DAMAGE.set(stack, (Object)amount);
        if (this.lightWeight(stack) && (cd = this.damageShield(player, stack, -1.0)) > 0 && player instanceof ServerPlayer) {
            player.getCooldowns().addCooldown((Item)this, cd);
            player.level().broadcastEntityEvent((Entity)player, (byte)30);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (!this.lightWeight(itemstack) && pHand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        pPlayer.startUsingItem(pHand);
        this.startUse(pPlayer);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        InteractionHand hand = pContext.getHand();
        Player player = pContext.getPlayer();
        if (!this.lightWeight(stack) && hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (player != null) {
            player.startUsingItem(hand);
            this.startUse(player);
            return InteractionResult.CONSUME;
        }
        return super.useOn(pContext);
    }

    protected void startUse(Player player) {
        LWPlayerData cap = LWPlayerData.get(player);
        cap.startReflectTimer(player);
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity user, int pTimeCharged) {
        if (user instanceof Player) {
            Player player = (Player)user;
            LWPlayerData cap = LWPlayerData.get(player);
            cap.clearReflectTimer();
        }
    }

    public boolean lightWeight(ItemStack stack) {
        return this.lightWeight;
    }

    public abstract double getDefenseRecover(ItemStack var1);

    public double getMaxDefense(LivingEntity player) {
        AttributeInstance attr = player.getAttribute(LWItems.SHIELD_DEFENSE.holder());
        if (attr == null) {
            return 20.0;
        }
        return attr.getValue();
    }

    public void onUseTick(Level pLevel, LivingEntity entity, ItemStack pStack, int pRemainingUseDuration) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer && (player = (ServerPlayer)entity).getCooldowns().isOnCooldown((Item)this)) {
            player.stopUsingItem();
        }
    }

    public int damageShield(Player player, ItemStack stack, double v) {
        return this.damageShieldImpl((LivingEntity)player, LWPlayerData.asData(player), stack, v);
    }

    public int damageShieldImpl(LivingEntity player, IShieldData cap, ItemStack stack, double v) {
        int damage = (Integer)LWItems.BLOCKED_DAMAGE.getOrDefault(stack, (Object)0);
        stack.remove(LWItems.BLOCKED_DAMAGE);
        double defense = cap.getShieldDefense();
        double max = this.getMaxDefense(player);
        double retain = cap.popRetain();
        double light = Math.max(0.0, (double)damage - retain);
        double heavy = Math.max(0.0, (double)damage * v - retain);
        defense += v < 0.0 ? light / max : (this.lightWeight(stack) ? v : heavy / this.getMaxDefense(player));
        if (defense >= 1.0) {
            cap.setShieldDefense(1.0);
            return 100;
        }
        cap.setShieldDefense(defense);
        return 0;
    }

    public double reflect(ItemStack stack, Player player, LivingEntity target) {
        return this.reflectImpl(stack, this.getReflectSource(player), player.getAttributeValue(Attributes.ATTACK_DAMAGE), LWPlayerData.asData(player), target);
    }

    protected void onBlock(ItemStack stack, LivingEntity user, LivingEntity target) {
    }

    protected double onReflect(ItemStack stack, LivingEntity user, LivingEntity target, double original, double reflect) {
        return reflect;
    }

    protected DamageSource getReflectSource(Player player) {
        return player.level().damageSources().playerAttack(player);
    }

    public double reflectImpl(ItemStack stack, DamageSource source, double additional, IShieldData data, LivingEntity target) {
        LivingEntity user = (LivingEntity)source.getEntity();
        assert (user != null);
        this.onBlock(stack, user, target);
        int damage = (Integer)LWItems.BLOCKED_DAMAGE.getOrDefault(stack, (Object)0);
        if (data.canReflect() && data.getReflectTimer() > 0) {
            double finalDamage = this.onReflect(stack, user, target, damage, (double)damage + additional);
            SchedulerHandler.schedule(() -> target.hurt(source, (float)finalDamage));
            return 2.0;
        }
        double extra = this.onReflect(stack, user, target, damage, 0.0);
        if (extra > 0.0) {
            SchedulerHandler.schedule(() -> target.hurt(source, (float)extra));
        }
        return 0.5;
    }
}

