/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.item.base;

import dev.xkmc.l2damagetracker.contents.attack.DamageData;
import dev.xkmc.l2damagetracker.contents.materials.generic.ExtraToolConfig;
import dev.xkmc.l2weaponry.content.item.base.DoubleWieldItem;
import dev.xkmc.l2weaponry.content.item.base.IStackableWeapon;
import dev.xkmc.l2weaponry.init.data.LWConfig;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;

public class BaseClawItem
extends DoubleWieldItem {
    public BaseClawItem(Tier tier, Item.Properties prop, ExtraToolConfig config) {
        super(tier, prop, config, (TagKey<Block>)BlockTags.MINEABLE_WITH_HOE);
    }

    @Override
    protected int getMaxStackUserBonus(int count, ItemStack stack, LivingEntity user) {
        if (user.getOffhandItem().getItem() == this) {
            return count * 2;
        }
        return count;
    }

    @Override
    protected int getMaxStackIntrinsic(ItemStack stack) {
        return (Integer)LWConfig.SERVER.claw_max.get();
    }

    @Override
    public float getMultiplier(DamageData.Offence event) {
        int count = IStackableWeapon.getHitCount(event.getWeapon());
        LivingEntity attacker = event.getAttacker();
        if (count > 0 && attacker != null) {
            int max = this.getMaxStack(event.getWeapon(), attacker);
            return (float)(1.0 + (Double)LWConfig.SERVER.claw_bonus.get() * (double)Mth.clamp((int)count, (int)0, (int)max));
        }
        return super.getMultiplier(event);
    }
}

