/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.entity;

import com.google.common.collect.Lists;
import dev.xkmc.l2complements.init.materials.LCMats;
import dev.xkmc.l2core.init.reg.ench.EnchHelper;
import dev.xkmc.l2weaponry.content.item.base.IThrowableCallback;
import dev.xkmc.l2weaponry.init.registrate.LWEnchantments;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

public class BaseThrownWeaponEntity<T extends BaseThrownWeaponEntity<T>>
extends AbstractArrow
implements IEntityWithComplexSpawn {
    private static final int LOWEST_HEIGHT = -32;
    private static final int MAX_DIST = 400;
    private static final int MAX_HOR_DIST = 100;
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(BaseThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(BaseThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int remainingHit = 1;
    public int clientSideReturnTridentTickCount;
    public int slot;
    public float waterInertia = 0.6f;
    @Nullable
    public Entity targetCache;
    @Nullable
    private Vec3 origin;

    public BaseThrownWeaponEntity(EntityType<T> type, Level pLevel) {
        super(type, pLevel);
        this.setItem(new ItemStack((ItemLike)Items.TRIDENT));
    }

    public BaseThrownWeaponEntity(EntityType<T> type, Level pLevel, LivingEntity pShooter, ItemStack pStack, int slot) {
        super(type, pShooter, pLevel, pStack, null);
        this.setItem(pStack.copy());
        this.slot = slot;
        int loyalty = EnchHelper.getLv((ItemStack)pStack, (ResourceKey)Enchantments.LOYALTY);
        if (LWEnchantments.PROJECTION.getLv(pStack) > 0) {
            loyalty = 0;
        }
        this.entityData.set(ID_LOYALTY, (Object)((byte)loyalty));
        this.entityData.set(ID_FOIL, (Object)pStack.hasFoil());
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public ItemStack getItem() {
        return this.getPickupItem();
    }

    public void setPierce(byte lv) {
        super.setPierceLevel(lv);
        this.remainingHit = lv + 1;
    }

    private void tickEarlyReturn() {
        Entity entity = this.getOwner();
        byte loyal = (Byte)this.entityData.get(ID_LOYALTY);
        if (this.isNoGravity() && this.getDeltaMovement().length() < 0.01) {
            this.remainingHit = 0;
            this.setNoGravity(false);
        }
        if (entity != null && loyal > 0 && this.remainingHit > 0) {
            if (this.origin == null) {
                this.origin = this.position();
            } else if (this.position().y < (double)(this.level().getMinBuildHeight() + -32)) {
                this.remainingHit = 0;
            } else {
                Vec3 diff = this.position().subtract(this.origin);
                if (diff.horizontalDistance() > 100.0 || diff.length() > 400.0) {
                    this.remainingHit = 0;
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_LOYALTY, (Object)0);
        builder.define(ID_FOIL, (Object)false);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.remainingHit = 0;
        }
        this.tickEarlyReturn();
        Entity entity = this.getOwner();
        byte loyal = (Byte)this.entityData.get(ID_LOYALTY);
        if (loyal > 0 && (this.remainingHit == 0 || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 vec3 = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3.y * 0.015 * (double)loyal, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)loyal;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.tick();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return this.remainingHit == 0 || this.isNoPhysics() ? null : super.findHitEntity(pStartVec, pEndVec);
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Entity entity = pResult.getEntity();
        float damage = (float)this.getBaseDamage();
        this.targetCache = entity;
        Entity owner = this.getOwner();
        DamageSource damagesource = this.level().damageSources().trident((Entity)this, (Entity)(owner == null ? this : owner));
        this.targetCache = null;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)sl, (ItemStack)this.getItem(), (Entity)entity, (DamageSource)damagesource, (float)damage);
        }
        if (this.remainingHit > 0) {
            --this.remainingHit;
            if (this.getPierceLevel() > 0) {
                if (this.piercingIgnoreEntityIds == null) {
                    this.piercingIgnoreEntityIds = new IntOpenHashSet(this.getPierceLevel() + 1);
                }
                if (this.piercedAndKilledEntities == null) {
                    this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
                }
                this.piercingIgnoreEntityIds.add(entity.getId());
            }
        }
        SoundEvent soundevent = SoundEvents.TRIDENT_HIT;
        if (entity.hurt(damagesource, damage)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            Level level2 = this.level();
            if (level2 instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)sl, (Entity)entity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
            }
            if (entity instanceof LivingEntity) {
                Item item;
                LivingEntity le = (LivingEntity)entity;
                this.doPostHurtEffects(le);
                if (!entity.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(entity);
                }
                if ((item = this.getPickupItem().getItem()) instanceof IThrowableCallback) {
                    IThrowableCallback cb = (IThrowableCallback)item;
                    cb.onHitEntity(this, this.getPickupItem(), le);
                }
            }
        }
        if (this.remainingHit == 0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        }
        float f1 = 1.0f;
        this.playSound(soundevent, f1, 1.0f);
    }

    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        ItemStack stack = this.getPickupItem();
        Item item = stack.getItem();
        if (item instanceof IThrowableCallback) {
            IThrowableCallback cb = (IThrowableCallback)item;
            cb.onHitBlock(this, stack);
        }
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void playerTouch(Player pEntity) {
        if (this.ownedBy((Entity)pEntity) || this.getOwner() == null) {
            super.playerTouch(pEntity);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.remainingHit = pCompound.getInt("RemainingHit");
        this.slot = pCompound.getInt("playerSlot");
        this.entityData.set(ID_LOYALTY, (Object)((byte)EnchHelper.getLv((ItemStack)this.getPickupItem(), (ResourceKey)Enchantments.LOYALTY)));
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("RemainingHit", this.remainingHit);
        pCompound.putInt("playerSlot", this.slot);
    }

    public void tickDespawn() {
        byte i = (Byte)this.entityData.get(ID_LOYALTY);
        if (this.pickup != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.tickDespawn();
        }
    }

    public boolean shouldRender(double pX, double pY, double pZ) {
        return true;
    }

    protected float getWaterInertia() {
        return this.waterInertia;
    }

    private void setItem(ItemStack item) {
        TieredItem tier;
        this.setPickupItemStack(item);
        Item item2 = item.getItem();
        this.waterInertia = item2 instanceof TieredItem && (tier = (TieredItem)item2).getTier() == LCMats.POSEIDITE.getTier() ? 0.99f : 0.6f;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buffer, (Object)this.getPickupItem());
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.setItem((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)additionalData));
    }
}

