/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.enchantments;

import com.google.common.base.Predicates;
import dev.xkmc.l2core.init.reg.ench.CustomDescEnchantment;
import dev.xkmc.l2core.init.reg.ench.EnchColor;
import dev.xkmc.l2core.init.reg.ench.LegacyEnchantment;
import dev.xkmc.l2damagetracker.contents.curios.AttrTooltip;
import dev.xkmc.l2weaponry.content.enchantments.AttributeEnchantment;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;

public class AttributeDescEnchantment
extends LegacyEnchantment
implements AttributeEnchantment,
CustomDescEnchantment {
    private final Entry[] entries;

    public AttributeDescEnchantment(Entry ... entries) {
        this.entries = entries;
    }

    @Override
    public void addAttributes(int level, ItemAttributeModifierEvent event) {
        for (Entry e : this.entries) {
            if (!e.pred.test(event.getItemStack())) continue;
            AttributeModifier mod = new AttributeModifier(this.id(), e.val.getAsDouble() * (double)level, e.op);
            event.addModifier(e.attr, mod, e.group);
        }
    }

    public List<Component> descFull(int lv, String key, boolean alt, boolean book, EnchColor color) {
        ArrayList<Component> ans = new ArrayList<Component>();
        ans.add((Component)Component.translatable((String)key).withStyle(color.desc()));
        for (Entry e : this.entries) {
            ans.add((Component)AttrTooltip.getDesc(e.attr, (double)(e.val.getAsDouble() * (double)lv), (AttributeModifier.Operation)e.op));
        }
        return ans;
    }

    public record Entry(Holder<Attribute> attr, DoubleSupplier val, AttributeModifier.Operation op, EquipmentSlotGroup group, Predicate<ItemStack> pred) {
        Entry(Holder<Attribute> attr, DoubleSupplier val, AttributeModifier.Operation op, EquipmentSlotGroup group) {
            this(attr, val, op, group, (Predicate<ItemStack>)Predicates.alwaysTrue());
        }
    }
}

