/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.client;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.l2weaponry.content.item.types.NunchakuItem;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class WeaponBEWLR
extends BlockEntityWithoutLevelRenderer {
    public static final Supplier<BlockEntityWithoutLevelRenderer> INSTANCE = Suppliers.memoize(() -> new WeaponBEWLR(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels()));
    public static final IClientItemExtensions EXTENSIONS = new IClientItemExtensions(){

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            return INSTANCE.get();
        }
    };

    public WeaponBEWLR(BlockEntityRenderDispatcher dispatcher, EntityModelSet set) {
        super(dispatcher, set);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext type, PoseStack pose, MultiBufferSource bufferSource, int light, int overlay) {
        Item item = stack.getItem();
        if (item instanceof NunchakuItem) {
            NunchakuItem nunchaku = (NunchakuItem)item;
            this.renderNunchaku(nunchaku, stack, type, pose, bufferSource, light, overlay);
        }
    }

    public void renderNunchaku(NunchakuItem nunchaku, ItemStack stack, ItemDisplayContext type, PoseStack pose, MultiBufferSource bufferSource, int light, int overlay) {
        ModelManager manager = Minecraft.getInstance().getModelManager();
        this.render(stack, type, false, pose, bufferSource, light, overlay, manager.getModel(nunchaku.unroll()), WeaponBEWLR::nunchakuUnroll);
        this.render(stack, type, false, pose, bufferSource, light, overlay, manager.getModel(nunchaku.roll()), WeaponBEWLR::nunchakuRoll);
    }

    private static void nunchakuUnroll(PoseStack pose) {
    }

    private static void nunchakuRoll(PoseStack pose) {
        float tick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true) + (float)Minecraft.getInstance().player.tickCount;
        pose.translate(1.0f, 1.0f, 0.0f);
        pose.rotateAround(Axis.ZP.rotationDegrees(tick * 72.0f), 0.0f, 0.0f, 0.0f);
    }

    public void render(ItemStack stack, ItemDisplayContext ctx, boolean offhand, PoseStack pose, MultiBufferSource buffer, int light, int overlay, BakedModel baked, Consumer<PoseStack> transform) {
        ItemRenderer ir = Minecraft.getInstance().getItemRenderer();
        if (!stack.isEmpty()) {
            pose.pushPose();
            transform.accept(pose);
            boolean flag1 = true;
            for (BakedModel model : baked.getRenderPasses(stack, flag1)) {
                for (RenderType rendertype : model.getRenderTypes(stack, flag1)) {
                    VertexConsumer vertexconsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.hasFoil());
                    ir.renderModelLists(model, stack, light, overlay, pose, vertexconsumer);
                }
            }
            pose.popPose();
        }
    }
}

