/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.l2weaponry.content.entity.BaseThrownWeaponEntity;
import dev.xkmc.l2weaponry.init.data.LWTagGen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;

public class ThrownWeaponRenderer<T extends BaseThrownWeaponEntity<T>>
extends EntityRenderer<T> {
    public static final ResourceLocation TRIDENT_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/trident.png");

    public ThrownWeaponRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(T entity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        if (!((BaseThrownWeaponEntity)((Object)entity)).getItem().is(LWTagGen.JAVELIN)) {
            pMatrixStack.translate(0.0, 0.25, 0.0);
        }
        pMatrixStack.scale(1.47f, 1.47f, 1.47f);
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)((BaseThrownWeaponEntity)((Object)entity)).yRotO, (float)entity.getYRot()) - 90.0f));
        pMatrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)((BaseThrownWeaponEntity)((Object)entity)).xRotO, (float)entity.getXRot()) - 90.0f));
        if (((BaseThrownWeaponEntity)((Object)entity)).getItem().is(LWTagGen.JAVELIN)) {
            pMatrixStack.translate(0.0, -0.4, 0.0);
        } else {
            pMatrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        pMatrixStack.mulPose(Axis.ZP.rotationDegrees(45.0f));
        ItemRenderer ir = Minecraft.getInstance().getItemRenderer();
        BakedModel model = ir.getModel(((BaseThrownWeaponEntity)((Object)entity)).getItem(), entity.level(), null, entity.getId());
        ir.render(((BaseThrownWeaponEntity)((Object)entity)).getItem(), ItemDisplayContext.GROUND, false, pMatrixStack, pBuffer, pPackedLight, OverlayTexture.NO_OVERLAY, model);
        pMatrixStack.popPose();
        super.render(entity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(T pEntity) {
        return TRIDENT_LOCATION;
    }
}

