/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2weaponry.content.client;

import dev.xkmc.l2core.init.L2CoreConfig;
import dev.xkmc.l2core.util.Proxy;
import dev.xkmc.l2weaponry.content.capability.IShieldData;
import dev.xkmc.l2weaponry.content.capability.LWPlayerData;
import dev.xkmc.l2weaponry.content.client.CommonDecoUtil;
import dev.xkmc.l2weaponry.content.item.base.BaseShieldItem;
import dev.xkmc.l2weaponry.init.registrate.LWItems;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.IItemDecorator;

public class ShieldItemDecorationRenderer
implements IItemDecorator {
    private static final int COLOR_REFLECT = -16711681;
    private static final int COLOR_USING = -32897;

    public boolean render(GuiGraphics g, Font font, ItemStack stack, int x, int y) {
        boolean using;
        LocalPlayer player = Proxy.getClientPlayer();
        if (player == null) {
            return false;
        }
        ItemStack main = player.getMainHandItem();
        if (main != stack) {
            if (player.getOffhandItem() != stack) {
                return false;
            }
            if (main.getItem() instanceof BaseShieldItem) {
                return false;
            }
        }
        if (!(stack.getItem() instanceof BaseShieldItem)) {
            return false;
        }
        g.pose().pushPose();
        int height = (Integer)L2CoreConfig.CLIENT.overlayZVal.get();
        g.pose().translate(0.0f, 0.0f, (float)height);
        LWPlayerData cap = LWPlayerData.get((Player)player);
        IShieldData data = LWPlayerData.asData((Player)player);
        float defenseLost = (float)data.getShieldDefense();
        float w = 13.0f * (1.0f - defenseLost);
        boolean bl = using = cap.getRecoverRate((Player)player) < 0.01;
        int color = data.canReflect() && defenseLost == 0.0f ? -16711681 : (using ? -32897 : -1);
        CommonDecoUtil.fillRect(g, x + 2, y + 14, w, 1.0f, color);
        CommonDecoUtil.fillRect(g, (float)(x + 2) + w, y + 14, 13.0f - w, 1.0f, -16777216);
        int reflectTimer = data.getReflectTimer();
        if (data.canReflect() && reflectTimer > 0) {
            int max = (int)player.getAttributeValue(LWItems.REFLECT_TIME.holder());
            w = 13.0f * (float)reflectTimer / (float)max;
            CommonDecoUtil.fillRect(g, x + 2, y + 14, w, 1.0f, -16711681);
        }
        g.pose().popPose();
        return true;
    }
}

